% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.cidprop.R
\name{plot.cidprop}
\alias{plot.cidprop}
\title{Plot density of prediction distribution highlighting areas of clinically
important benefit or harm}
\usage{
\method{plot}{cidprop}(
  x,
  cid = NULL,
  cid.below.null = x$cid.below.null,
  cid.above.null = x$cid.above.null,
  label.cid = "",
  label.cid.below.null = x$label.cid.below.null,
  label.cid.above.null = x$label.cid.above.null,
  small.values = x$small.values,
  fill.cid.below.null = NULL,
  fill.cid.above.null = NULL,
  fill = "white",
  legend = FALSE,
  studies = TRUE,
  random = TRUE,
  col.diamond = gs("col.diamond"),
  col.diamond.lines = gs("col.diamond.lines"),
  prediction = TRUE,
  col.predict = gs("col.predict"),
  col.predict.lines = gs("col.predict.lines"),
  big.mark = gs("big.mark"),
  digits.cid = gs("digits.cid"),
  digits.percent = 1,
  digits.xaxis = gs("digits.forest"),
  xlab = NULL,
  ylab = NULL,
  xlim = NULL,
  ylim = NULL,
  labels.x = NULL,
  ...
)
}
\arguments{
\item{x}{An object of class \code{cidprop}.}

\item{cid}{A numeric value or vector specifying clinically important
differences (CID) / decision thresholds used to calculate expected
proportions of clinically important benefit or harm (see Details).}

\item{cid.below.null}{A numeric value or vector specifying CID limits below
the null effect (see Details).}

\item{cid.above.null}{A numeric value or vector specifying CID limits above
the null effect (see Details).}

\item{label.cid}{A character string or vector specifying labels for
clinically important differences. Must be of same length as argument
\code{cid}.}

\item{label.cid.below.null}{A character string or vector specifying labels
for clinically important differences below the null effect. Must be of
same length as argument \code{cid.below.null} (or \code{cid}).}

\item{label.cid.above.null}{A character string or vector specifying labels
for clinically important differences above the null effect. Must be of
same length as argument \code{cid.above.null} (or \code{cid}).}

\item{small.values}{A character string specifying whether small
treatment effects indicate a beneficial (\code{"desirable"}) or
harmful (\code{"undesirable"}), can be abbreviated.}

\item{fill.cid.below.null}{Background colour(s) for CID areas below null
effect.}

\item{fill.cid.above.null}{Background colour(s) for CID areas above null
effect.}

\item{fill}{Background colour for area between decision thresholds.}

\item{legend}{A logical indicating whether to print a legend with
expected proportions of beneficial, harmful, or not important effects.}

\item{studies}{A logical indicating whether to print estimates of individual
studies.}

\item{random}{A logical indicating whether to show diamond of the random
effects meta-analysis.}

\item{col.diamond}{The colour of the diamond representing the results
for the random effects model.}

\item{col.diamond.lines}{The colour of the outer lines of the diamond
representing the results of the random effects model.}

\item{prediction}{A logical indicating whether to show the prediction
interval.}

\item{col.predict}{The colour of the prediction interval.}

\item{col.predict.lines}{The colour of the outer lines of the prediction
interval.}

\item{big.mark}{A character used as thousands separator.}

\item{digits.cid}{Minimal number of significant digits for
decision thresholds, see \code{\link{print.default}}.}

\item{digits.percent}{Minimal number of significant digits for
expected proportions, printed as percentages, see
\code{\link{print.default}}.}

\item{digits.xaxis}{Minimal number of significant digits for
labels on x-axis, see \code{\link{print.default}}.}

\item{xlab}{Label on x-axis.}

\item{ylab}{Label on y-axis.}

\item{xlim}{Limits for x-axis.}

\item{ylim}{Limits for y-axis.}

\item{labels.x}{Predefined labels for tick marks on x-axis.}

\item{\dots}{Additional arguments (ignored)}
}
\value{
A ggplot object with additional class 'plot.cidprop'.
}
\description{
Plot density of prediction distribution highlighting areas of clinically
important benefit or harm
}
\details{
Arguments \code{cid}, \code{cid.below.null}, \code{cid.above.null},
\code{label.cid}, \code{label.cid.below.null}, \code{label.cid.above.null},
and \code{small.values} are identical to the main arguments of R function
\code{\link{cidprop}} which is called internally if any of these values has
been provided by the user.

R packages \bold{ggpubr} and \bold{gridExtra} must be installed in order to
add a legend to the plot with the CIDs, expected proportions of clinically
benefit or harm, and the area colours (due to using R functions
\code{ggarrange} and \code{tableGrob}). The data and colours shown in the
legend are stored in the attribute 'data.cid' of the returned ggplot object
(see Examples).

UTF-8 code for the less than or equal and greater than or equal signs are
used in the legend. Accordingly, graphic devices with full UTF-8 support are
required to save graphics, for example, \code{\link[grDevices]{cairo_pdf}}
instead of \code{\link[grDevices]{pdf}} from R package \bold{grDevices}.
}
\examples{
oldset <- settings.meta(digits.cid = 0)

m <- metagen(1:10 - 3, 1:10, sm = "MD")

pp1 <- cidprop(m, cid = 2)
pp1
plot(pp1, xlim = c(-4, 4))
\donttest{
pp2 <- cidprop(m, cid.below.null = 0.5, cid.above.null = 2)
pp2
plot(pp2, xlim = c(-4, 4))

pp3 <- cidprop(m, cid.below.null = 0.5, cid.above.null = 2,
  small.values = "u")
pp3
plot(pp3, xlim = c(-4, 4))

pp4 <- cidprop(m, cid = 1:2, label.cid = c("moderate", "large"))
pp4
plot(pp4, xlim = c(-4, 4))

pp5 <- cidprop(m, cid.below.null = -1.5, cid.above.null = 1:2,
  label.cid.below.null = "large",
  label.cid.above.null = c("moderate", "large"))
pp5
plpp5 <- plot(pp5, xlim = c(-4, 4))
plpp5
# Information on CIDs and colours
attr(plpp5, "data.cid")
}
\dontrun{
# R packages 'ggpubr' and 'gridExtra' must be available
if (requireNamespace("ggpubr", quietly = TRUE) &
    requireNamespace("gridExtra", quietly = TRUE)) {
  plot(pp1, xlim = c(-4, 4), legend = TRUE)
}
}

settings.meta(oldset)

}
\seealso{
\code{\link{cidprop}}
}
\author{
Guido Schwarzer \email{guido.schwarzer@uniklinik-freiburg.de}
}
