% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auth-ci.R
\name{meetupr_encrypt}
\alias{meetupr_encrypt}
\alias{meetupr_encrypt_setup}
\alias{meetupr_encrypt_load}
\alias{get_encrypted_path}
\title{CI Authentication with Encrypted Token Rotation}
\usage{
meetupr_encrypt_setup(
  path = ".meetupr.rds",
  password = NULL,
  client_name = get_client_name(),
  ...
)

meetupr_encrypt_load(
  path = get_encrypted_path(),
  client_name = get_client_name(),
  password = meetupr_key_get("encrypt_pwd", client_name = client_name),
  ...
)

get_encrypted_path(client_name = get_client_name())
}
\arguments{
\item{path}{Path to encrypted token file. Default
\code{".meetupr.rds"}.}

\item{password}{Encryption password. If NULL, generates random
password.}

\item{client_name}{A string representing the name of the client. By
default, it is set to \code{"meetupr"} and retrieved from the
\code{MEETUPR_CLIENT_NAME} environment variable.}

\item{...}{Additional arguments to \code{\link[=meetupr_client]{meetupr_client()}}.}
}
\value{
\itemize{
\item \code{\link[=meetupr_encrypt_setup]{meetupr_encrypt_setup()}}: Encryption password (invisibly)
\item \code{\link[=meetupr_encrypt_load]{meetupr_encrypt_load()}}: httr2_token object
}
}
\description{
Manage Meetup API authentication in CI environments using
encrypted tokens that auto-refresh when expired.
}
\details{
Setup: Run \code{\link[=meetupr_auth]{meetupr_auth()}}, then \code{\link[=meetupr_encrypt_setup]{meetupr_encrypt_setup()}}. Commit
the encrypted file and add password to CI secrets as
\code{meetupr_encrypt_pwd}.

\code{\link[=meetupr_encrypt_load]{meetupr_encrypt_load()}} checks token expiration and refreshes only
when needed, saving the rotated token back to the encrypted
file.
}
\section{Functions}{
\itemize{
\item \code{meetupr_encrypt_setup()}: Setup encrypted token for CI

\item \code{meetupr_encrypt_load()}: Load and refresh encrypted token

\item \code{get_encrypted_path()}: Get encrypted token path

}}
\examples{
\dontrun{
meetupr_auth()
password <- meetupr_encrypt_setup()

# In CI
token <- meetupr_encrypt_load()
}

}
