% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_spatial_day.R
\name{spwb_spatial_day}
\alias{spwb_spatial_day}
\alias{growth_spatial_day}
\title{One-day simulation for spatially-distributed forest stands}
\usage{
spwb_spatial_day(
  sf,
  meteo = NULL,
  date,
  SpParams,
  local_control = defaultControl(),
  parallelize = FALSE,
  num_cores = detectCores() - 1,
  chunk_size = NULL,
  progress = TRUE
)

growth_spatial_day(
  sf,
  meteo = NULL,
  date,
  SpParams,
  local_control = defaultControl(),
  parallelize = FALSE,
  num_cores = detectCores() - 1,
  chunk_size = NULL,
  progress = TRUE
)
}
\arguments{
\item{sf}{An object of class \code{\link[sf]{sf}} with landscape information (see \code{\link{spwb_spatial}}).}

\item{meteo}{Meteorology data (see \code{\link{spwb_spatial}}).}

\item{date}{A string with the date to be simulated.}

\item{SpParams}{A data frame with species parameters (see \code{\link[medfate]{SpParamsMED}}).}

\item{local_control}{A list of local model control parameters (see \code{\link[medfate]{defaultControl}}).}

\item{parallelize}{Boolean flag to try parallelization (will use all clusters minus one).}

\item{num_cores}{Integer with the number of cores to be used for parallel computation.}

\item{chunk_size}{Integer indicating the size of chunks to be sent to different processes (by default, the number of spatial elements divided by the number of cores).}

\item{progress}{Boolean flag to display progress information for simulations.}
}
\value{
An object of class \code{\link[sf]{sf}} the same name as the function called containing three elements:
\itemize{
\item{\code{geometry}: Spatial geometry.}
\item{\code{id}: Stand id, taken from the input.}
\item{\code{state}: A list of model input objects for each simulated stand, to be used in subsequent simulations.}
\item{\code{result}: A list of model output for each simulated stand.}
}
}
\description{
Functions that allow calling local models \code{\link[medfate]{spwb_day}} or \code{\link[medfate]{growth_day}},
for a set of forest stands distributed in specific locations and a given date.
No spatial processes are simulated.
}
\details{
Simulation functions accept different formats for meteorological input (described in \code{\link{spwb_spatial}}).
}
\examples{
\donttest{
#Load example landscape data
data("example_ifn")

#Load example meteo data frame from package meteoland
data("examplemeteo")
  
#Load default medfate parameters
data("SpParamsMED")
  
#Perform simulation
date <- "2001-03-01"
res <- spwb_spatial_day(example_ifn, examplemeteo, date, SpParamsMED)
}
}
\seealso{
\code{\link[medfate]{spwb_day}}, \code{\link[medfate]{growth_day}}, \code{\link{spwb_spatial}}
}
\author{
Miquel De \enc{Cáceres}{Caceres} Ainsa, CREAF
}
