% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_eval.R
\encoding{UTF-8}
\name{model-information-criteria}
\alias{model-information-criteria}
\alias{compute_DIC}
\alias{compute_WAIC}
\alias{waic.mcdraws}
\alias{loo.mcdraws}
\title{Compute DIC, WAIC and leave-one-out cross-validation model measures}
\usage{
compute_DIC(x, use.pV = FALSE)

compute_WAIC(
  x,
  diagnostic = FALSE,
  batch.size = NULL,
  show.progress = TRUE,
  cl = NULL,
  n.cores = 1L
)

\method{waic}{mcdraws}(x, by.unit = FALSE, ...)

\method{loo}{mcdraws}(x, by.unit = FALSE, r_eff = FALSE, n.cores = 1L, ...)
}
\arguments{
\item{x}{an object of class \code{mcdraws}.}

\item{use.pV}{whether half the posterior variance of the deviance should be used
as an alternative estimate of the effective number of model parameters for DIC.}

\item{diagnostic}{whether vectors of log-pointwise-predictive-densities and pointwise
contributions to the WAIC effective number of model parameters should be returned.}

\item{batch.size}{number of data units to process per batch.}

\item{show.progress}{whether to show a progress bar.}

\item{cl}{an existing cluster can be passed for parallel computation. If \code{cl} is provided,
\code{n.cores} will be set to the number of workers in that cluster. If \code{NULL} and
\code{n.cores > 1}, a new cluster is created.}

\item{n.cores}{the number of cpu cores to use. Default is one, i.e. no parallel computation.}

\item{by.unit}{if \code{TRUE} the computation is carried out unit-by-unit, which is
slower but uses much less memory.}

\item{...}{Other arguments, passed to \code{\link[loo]{loo}}. Not currently
used by \code{waic.mcdraws}.}

\item{r_eff}{whether to compute relative effective sample size estimates
for the likelihood of each observation. This takes more time, but should
result in a better PSIS approximation. See \code{\link[loo]{loo}}.}
}
\value{
For \code{compute_DIC} a vector with the deviance information criterion and
 effective number of model parameters. For \code{compute_WAIC} a vector with the
 WAIC model selection criterion and WAIC effective number of model parameters.
 Method \code{waic} returns an object of class \code{waic, loo}, see the
 documentation for \code{\link[loo]{waic}} in package \pkg{loo}. 
 Method \code{loo} returns an object of class \code{psis_loo}, see
 \code{\link[loo]{loo}}.
}
\description{
Compute the Deviance Information Criterion (DIC) or
Watanabe-Akaike Information Criterion (WAIC) from an
object of class \code{mcdraws} output by \code{\link{MCMCsim}}.
Method \code{waic.mcdraws} computes WAIC using package \pkg{loo}.
Method \code{loo.mcdraws} also depends on package \pkg{loo} to compute
a Pareto-smoothed importance sampling (PSIS) approximation
to leave-one-out cross-validation.
}
\examples{
\donttest{
ex <- mcmcsae_example(n=100)
sampler <- create_sampler(ex$model, data=ex$dat)
sim <- MCMCsim(sampler, burnin=100, n.iter=300, n.chain=4, store.all=TRUE)
compute_DIC(sim)
compute_WAIC(sim)
if (require(loo)) {
  waic(sim)
  loo(sim, r_eff=TRUE)
}
}

}
\references{
D. Spiegelhalter, N. Best, B. Carlin and A. van der Linde (2002).
   Bayesian Measures of Model Complexity and Fit.
   Journal of the Royal Statistical Society B 64 (4), 583-639.

 S. Watanabe (2010).
   Asymptotic equivalence of Bayes cross validation and widely applicable
   information criterion in singular learning theory.
   Journal of Machine Learning 11, 3571-3594.

 A. Gelman, J. Hwang and A. Vehtari (2014).
   Understanding predictive information criteria for Bayesian models.
   Statistics and Computing 24, 997-1016.

 A. Vehtari, D. Simpson, A. Gelman, Y. Yao and J. Gabry (2024).
   Pareto smoothed importance sampling.
   arXiv:1507.02646v9.

 A. Vehtari, A. Gelman and J. Gabry (2017).
   Practical Bayesian model evaluation using leave-one-out cross-validation
   and WAIC.
   Statistics and Computing 27, 1413-1432.

 P.-C. Buerkner, J. Gabry and A. Vehtari (2021).
   Efficient leave-one-out cross-validation for Bayesian non-factorized
   normal and Student-t models.
   Computational Statistics 36, 1243-1261.
}
