% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process_step_space.R
\name{process_step_space}
\alias{process_step_space}
\title{Process Space-Separated KOs with Mean Calculation}
\usage{
process_step_space(
  module_abundance,
  KOs = c("K14126 K14127 K14128"),
  aggregrate_rowname,
  step_count = 1
)
}
\arguments{
\item{module_abundance}{Data frame containing KO abundance data with required columns:
Orthology_Entry, Module_Entry, Definition}

\item{KOs}{Character string of space-separated KO IDs (default: "K14126 K14127 K14128")}

\item{aggregrate_rowname}{Base name for row aggregation (default: 'step_1')}

\item{step_count}{Processing step counter (default: 1)}
}
\value{
List containing:
- abundance_table: Processed data with mean values
- step_count: Updated step counter
- abundance_log: log
}
\description{
Handles space-separated KOs by calculating the mean abundance across all specified KOs.
Processes multiple KOs separated by spaces and aggregates them into a single row.
Note: For mean calculation, uses the sum of KO abundances divided by total number of KOs,
including those with zero abundance in all samples.
}
