% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mc_variability.R
\name{mc_variability}
\alias{mc_variability}
\title{Variability Matrix}
\usage{
mc_variability(sensitivity, product, inv_C, C, res, W)
}
\arguments{
\item{sensitivity}{A numeric matrix representing the sensitivity matrix.
Typically obtained from \code{\link{mc_sensitivity}}.}

\item{product}{A list of numeric matrices, usually used to compute
contributions to the variability matrix.}

\item{inv_C}{A numeric matrix representing the inverse of the covariance
matrix, usually obtained from \code{\link{mc_build_C}}.}

\item{C}{A numeric matrix representing the covariance matrix, usually
obtained from \code{\link{mc_build_C}}.}

\item{res}{A numeric vector of residuals, defined as \eqn{y - \mu}.}

\item{W}{A numeric matrix of weights.}
}
\value{
A symmetric numeric matrix representing the variability matrix associated
with the Pearson estimating function. The returned object is intended for internal use only.
}
\description{
Computes the variability matrix associated with the Pearson estimating
function. This function is intended for internal use in the fitting
algorithm and implements Equation 8 from Bonat and Jorgensen (2016).
}
\details{
This function implements Equation 8 from Bonat and Jorgensen (2016), which
defines the variability matrix used in generalized estimating equations
for multiple response variables.
}
\author{
Wagner Hugo Bonat
}
\keyword{internal}
