% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mc_mixed.R
\name{mc_mixed}
\alias{mc_mixed}
\title{Mixed Models Structure}
\source{
Bonat, W. H. (2018). Multiple Response Variables Regression Models in R:
The mcglm Package. Journal of Statistical Software, 84(4), 1--30.

Bonat, W. H., et al. (2016). Modelling the covariance structure in
marginal multivariate count models: Hunting in Bioko Island.
Journal of Agricultural, Biological, and Environmental Statistics,
22(4), 446--464.
}
\usage{
mc_mixed(formula, data)
}
\arguments{
\item{formula}{A model formula specifying the structure of the matrix
linear predictor for the dispersion component. The first term must
remove the intercept (\code{0 +}), and the second term must identify
the grouping variable (e.g., subject or unit), which must be a
\code{factor}. Additional covariates may be specified after a slash
(\code{/}) to define random slopes and associated covariance
components.}

\item{data}{A \code{data.frame} containing all variables referenced in
\code{formula}.}
}
\value{
A list of symmetric sparse matrices of class \code{"dsCMatrix"}, each
corresponding to a variance or covariance component of the matrix
linear predictor for the dispersion structure. The list includes
matrices associated with main effects and, by default, their pairwise
interaction terms as implied by the mixed-effects specification in the
formula. These matrices are used internally to construct the linear
predictor of the covariance model in \code{mcglm}. It is intended to be
supplied to the \code{matrix_pred} argument of \code{\link{mcglm}}.
}
\description{
Constructs the components of the matrix linear predictor associated
with mixed-effects covariance structures in multivariate covariance
generalized linear models. The function builds symmetric matrices
representing variance and covariance components as functions of known
covariates, following a linear mixed model formulation.

The \code{mc_mixed} function is primarily intended for repeated measures
and longitudinal data, where observations are collected within a fixed
number of groups, subjects, or experimental units.
}
\details{
The \code{formula} argument follows a syntax similar to that used for
linear mixed models. The grouping variable must be provided as the
second term in the formula and must be a \code{factor}; no internal
coercion is performed. Covariates specified after the slash
(\code{/}) may be continuous or categorical and define additional
variance and covariance components. When only the grouping variable
is specified (e.g., \code{~ 0 + SUBJECT}), the resulting structure
corresponds to the compound symmetry covariance model.

By default, all pairwise interaction terms between components are
included in the matrix linear predictor. Interaction terms may be
excluded by removing the corresponding components from the resulting
list.
}
\examples{
SUBJECT <- gl(2, 6)
x1 <- rep(1:6, 2)
x2 <- rep(gl(2, 3), 2)
data <- data.frame(SUBJECT, x1, x2)

# Compound symmetry structure
mc_mixed(~ 0 + SUBJECT, data = data)

# Compound symmetry with random slope for x1
mc_mixed(~ 0 + SUBJECT/x1, data = data)

# Compound symmetry with random slopes for x1 and x2 and interactions
mc_mixed(~ 0 + SUBJECT/(x1 + x2), data = data)

}
\seealso{
\code{mc_id}, \code{mc_conditional_test}, \code{mc_dist},
\code{mc_ma}, \code{mc_rw}, \code{mc_car}
}
\author{
Wagner Hugo Bonat, \email{wbonat@ufpr.br}
}
