% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mc_link_function.R
\name{mc_link_function}
\alias{mc_link_function}
\alias{mc_logit}
\alias{mc_probit}
\alias{mc_cauchit}
\alias{mc_cloglog}
\alias{mc_loglog}
\alias{mc_identity}
\alias{mc_log}
\alias{mc_sqrt}
\alias{mc_invmu2}
\alias{mc_inverse}
\title{Link Functions}
\usage{
mc_link_function(beta, X, offset, link)

mc_logit(beta, X, offset)

mc_probit(beta, X, offset)

mc_cauchit(beta, X, offset)

mc_cloglog(beta, X, offset)

mc_loglog(beta, X, offset)

mc_identity(beta, X, offset)

mc_log(beta, X, offset)

mc_sqrt(beta, X, offset)

mc_invmu2(beta, X, offset)

mc_inverse(beta, X, offset)
}
\arguments{
\item{beta}{a numeric vector of regression parameters.}

\item{X}{a design matrix, see \code{\link[stats]{model.matrix}} for
details.}

\item{offset}{a numeric vector of offset values. It will be sum up on
the linear predictor as a covariate with known regression
parameter equals one (\eqn{\mu = g^{-1}(X\beta + offset)}).  If
no offset is present in the model, set offset = NULL.}

\item{link}{a string specifying the name of the link function.
Options are: \code{"logit"}, \code{"probit"}, \code{"cauchit"},
\code{"cloglog"}, \code{"loglog"}, \code{"identity"}, \code{"log"},
\code{"sqrt"}, \code{"1/mu^2"} and \code{inverse}.
A user defined link function can be used (see Details).}
}
\value{
A list with the following components:
\describe{
  \item{mu}{A numeric vector of length \eqn{n} containing the mean
  response values obtained by applying the inverse link function to
  the linear predictor.}
  \item{D}{A numeric matrix of dimension \eqn{n \times p} containing
  the derivatives of \eqn{\mu} with respect to the regression parameters
  \eqn{\beta}.}
}
}
\description{
The \code{mc_link_function} is a customized call of the
\code{\link[stats]{make.link}} function.

Given the name of a link function, it returns a list with two
elements.  The first element is the inverse of the link function
applied on the linear predictor \eqn{\mu = g^{-1}(X\beta).} The
second element is the derivative of \eqn{\mu} with respect to the
regression parameters \eqn{\beta}.
It will be useful when computing the quasi-score function.
}
\details{
The link function is an important component of the
    multivariate covariance generalized linear models, since it links
    the expectation of the response variable with the covariates.
    Let \eqn{\beta} be a (p x 1) regression parameter vector and
    \eqn{X} be an (n x p) design matrix. The expected value of
    the response variable \eqn{Y} is given by \deqn{E(Y) =
    g^{-1}(X\beta),} where \eqn{g} is the link function and \eqn{\eta
    = X\beta} is the linear predictor. Let \eqn{D} be a (n x p)
    matrix whose entries are given by the derivatives of \eqn{\mu}
    with respect to \eqn{\beta}.  Such a matrix will be required for the
    fitting algorithm. The function \code{mc_link_function} returns a
    list where the first element is \eqn{\mu} (n x 1) vector
    and the second is the D (n x p) matrix.
    A user defined function can also be used. It must be a function
    with arguments \code{beta}, \code{X} and \code{offset}
    (set to \code{NULL} if non needed). The function must return a
    length 2 named list with \code{mu} and \code{D} elements as a
    vector and a matrix of proper dimensions.
}
\examples{
x1 <- seq(-1, 1, l = 5)
X <- model.matrix(~ x1)
mc_link_function(beta = c(1,0.5), X = X,
                 offset = NULL, link = 'log')
mc_link_function(beta = c(1,0.5), X = X,
                 offset = rep(10,5), link = 'identity')
}
\seealso{
\code{\link[stats]{model.matrix}},
    \code{\link[stats]{make.link}}.
}
\author{
Wagner Hugo Bonat, \email{wbonat@ufpr.br}
}
