% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mc_S3_methods.R
\name{confint.mcglm}
\alias{confint.mcglm}
\title{Confidence Intervals for Model Parameters}
\usage{
\method{confint}{mcglm}(object, parm, level = 0.95, ...)
}
\arguments{
\item{object}{A fitted object of class \code{mcglm}.}

\item{parm}{Optional specification of parameters for which confidence intervals
are required. Can be a numeric vector of indices or a character
vector of parameter names. If omitted, confidence intervals for all
parameters are returned.}

\item{level}{Numeric value giving the confidence level. Must be between 0 and 1.
Default is \code{0.95}.}

\item{...}{Additional arguments. Currently ignored and included for
compatibility with the generic
\code{\link[stats]{confint}} function.}
}
\value{
A numeric matrix with two columns corresponding to the lower and
upper confidence limits. Rows correspond to model parameters.
}
\description{
Computes Wald-type confidence intervals for parameter estimates
from a fitted \code{mcglm} model, based on asymptotic normality.
}
\author{
Wagner Hugo Bonat, \email{wbonat@ufpr.br}
}
