% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AuditorFitters.R
\name{CVLearnerAuditorFitter}
\alias{CVLearnerAuditorFitter}
\alias{CVTreeAuditorFitter}
\alias{CVRidgeAuditorFitter}
\title{Cross-validated AuditorFitter from a Learner}
\value{
\code{\link{AuditorFitter}}\cr

\code{list} with items\cr
\itemize{
\item \code{corr}: pseudo-correlation between residuals and learner prediction.
\item \code{l}: the trained learner.
}
}
\description{
CVLearnerAuditorFitter returns the cross-validated predictions
instead of the in-sample predictions.

Available data is cut into complementary subsets (folds).
For each subset out-of-sample predictions are received by training a model
on all other subsets and predicting afterwards on the left-out subset.
}
\section{Functions}{
\itemize{
\item \code{CVTreeAuditorFitter}: Cross-Validated auditor based on rpart

\item \code{CVRidgeAuditorFitter}: Cross-Validated auditor based on glmnet

}}
\seealso{
Other AuditorFitter: 
\code{\link{LearnerAuditorFitter}},
\code{\link{SubgroupAuditorFitter}},
\code{\link{SubpopAuditorFitter}}

Other AuditorFitter: 
\code{\link{LearnerAuditorFitter}},
\code{\link{SubgroupAuditorFitter}},
\code{\link{SubpopAuditorFitter}}

Other AuditorFitter: 
\code{\link{LearnerAuditorFitter}},
\code{\link{SubgroupAuditorFitter}},
\code{\link{SubpopAuditorFitter}}
}
\concept{AuditorFitter}
\section{Super class}{
\code{\link[mcboost:AuditorFitter]{mcboost::AuditorFitter}} -> \code{CVLearnerAuditorFitter}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{learner}}{\code{CVLearnerPredictor}\cr
Learner used for fitting residuals.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-CVLearnerAuditorFitter-new}{\code{CVLearnerAuditorFitter$new()}}
\item \href{#method-CVLearnerAuditorFitter-fit}{\code{CVLearnerAuditorFitter$fit()}}
\item \href{#method-CVLearnerAuditorFitter-clone}{\code{CVLearnerAuditorFitter$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="mcboost" data-topic="AuditorFitter" data-id="fit_to_resid"><a href='../../mcboost/html/AuditorFitter.html#method-AuditorFitter-fit_to_resid'><code>mcboost::AuditorFitter$fit_to_resid()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CVLearnerAuditorFitter-new"></a>}}
\if{latex}{\out{\hypertarget{method-CVLearnerAuditorFitter-new}{}}}
\subsection{Method \code{new()}}{
Define a \code{CVAuditorFitter} from a learner.
Available instantiations:\cr \code{\link{CVTreeAuditorFitter}} (rpart) and
\code{\link{CVRidgeAuditorFitter}} (glmnet).
See \code{\link[mlr3pipelines:mlr_pipeops_learner_cv]{mlr3pipelines::PipeOpLearnerCV}} for more information on
cross-validated learners.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CVLearnerAuditorFitter$new(learner, folds = 3L)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{learner}}{\code{\link[mlr3:Learner]{mlr3::Learner}}\cr
Regression Learner to use.}

\item{\code{folds}}{\code{\link{integer}}\cr
Number of folds to use for PipeOpLearnerCV. Defaults to 3.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CVLearnerAuditorFitter-fit"></a>}}
\if{latex}{\out{\hypertarget{method-CVLearnerAuditorFitter-fit}{}}}
\subsection{Method \code{fit()}}{
Fit the cross-validated learner and compute correlation
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CVLearnerAuditorFitter$fit(data, resid, mask)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data}}{\code{\link[data.table:data.table]{data.table}}\cr
Features.}

\item{\code{resid}}{\code{\link{numeric}}\cr
Residuals (of same length as data).}

\item{\code{mask}}{\code{\link{integer}}\cr
Mask applied to the data. Only used for \code{SubgroupAuditorFitter}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CVLearnerAuditorFitter-clone"></a>}}
\if{latex}{\out{\hypertarget{method-CVLearnerAuditorFitter-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CVLearnerAuditorFitter$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
\section{Super classes}{
\code{\link[mcboost:AuditorFitter]{mcboost::AuditorFitter}} -> \code{\link[mcboost:CVLearnerAuditorFitter]{mcboost::CVLearnerAuditorFitter}} -> \code{CVTreeAuditorFitter}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-CVTreeAuditorFitter-new}{\code{CVTreeAuditorFitter$new()}}
\item \href{#method-CVTreeAuditorFitter-clone}{\code{CVTreeAuditorFitter$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="mcboost" data-topic="AuditorFitter" data-id="fit_to_resid"><a href='../../mcboost/html/AuditorFitter.html#method-AuditorFitter-fit_to_resid'><code>mcboost::AuditorFitter$fit_to_resid()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mcboost" data-topic="CVLearnerAuditorFitter" data-id="fit"><a href='../../mcboost/html/CVLearnerAuditorFitter.html#method-CVLearnerAuditorFitter-fit'><code>mcboost::CVLearnerAuditorFitter$fit()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CVTreeAuditorFitter-new"></a>}}
\if{latex}{\out{\hypertarget{method-CVTreeAuditorFitter-new}{}}}
\subsection{Method \code{new()}}{
Define a cross-validated AuditorFitter from a rpart learner
See \code{\link[mlr3pipelines:mlr_pipeops_learner_cv]{mlr3pipelines::PipeOpLearnerCV}} for more information on
cross-validated learners.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CVTreeAuditorFitter$new()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CVTreeAuditorFitter-clone"></a>}}
\if{latex}{\out{\hypertarget{method-CVTreeAuditorFitter-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CVTreeAuditorFitter$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
\section{Super classes}{
\code{\link[mcboost:AuditorFitter]{mcboost::AuditorFitter}} -> \code{\link[mcboost:CVLearnerAuditorFitter]{mcboost::CVLearnerAuditorFitter}} -> \code{CVRidgeAuditorFitter}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-CVRidgeAuditorFitter-new}{\code{CVRidgeAuditorFitter$new()}}
\item \href{#method-CVRidgeAuditorFitter-clone}{\code{CVRidgeAuditorFitter$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="mcboost" data-topic="AuditorFitter" data-id="fit_to_resid"><a href='../../mcboost/html/AuditorFitter.html#method-AuditorFitter-fit_to_resid'><code>mcboost::AuditorFitter$fit_to_resid()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mcboost" data-topic="CVLearnerAuditorFitter" data-id="fit"><a href='../../mcboost/html/CVLearnerAuditorFitter.html#method-CVLearnerAuditorFitter-fit'><code>mcboost::CVLearnerAuditorFitter$fit()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CVRidgeAuditorFitter-new"></a>}}
\if{latex}{\out{\hypertarget{method-CVRidgeAuditorFitter-new}{}}}
\subsection{Method \code{new()}}{
Define a cross-validated AuditorFitter from a glmnet learner.
See \code{\link[mlr3pipelines:mlr_pipeops_learner_cv]{mlr3pipelines::PipeOpLearnerCV}} for more information on
cross-validated learners.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CVRidgeAuditorFitter$new()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CVRidgeAuditorFitter-clone"></a>}}
\if{latex}{\out{\hypertarget{method-CVRidgeAuditorFitter-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CVRidgeAuditorFitter$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
