% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_model.R
\name{compute_model}
\alias{compute_model}
\title{Evaluation of decision tree nodes}
\usage{
compute_model(tree, utilities, weights)
}
\arguments{
\item{tree}{initial tree structure with utilities in its leafs.}

\item{utilities}{data.table with ordered columns containing the values of utilities.}

\item{weights}{weights for the decision model.}
}
\value{
data.table structure containing the utilities of the model for every level the decision
tree.
}
\description{
Evaluation of decision tree nodes. All the MAUT model is computed at every level 
the utilities are computed considering the given weights.
}
\details{
The whole decision model can be computed a any level and represented in a table format.
}
\examples{
vignette( topic = 'Running_MAUT', package = 'mau' )
}
\seealso{
\code{\link{stand_string}}, \code{\link{read_utilities}}, \code{\link{eval_utilities}},
\code{\link{read_tree}}, \code{\link{make_decision_tree}}, \code{\link{sim_const_weights}}.
}
\author{
Pedro Guarderas, Andrés Lopez
\email{pedro.felipe.guarderas@gmail.com}
}
