% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/excel.R
\name{write_mats_to_excel}
\alias{write_mats_to_excel}
\title{Write matrices to an Excel file}
\usage{
write_mats_to_excel(
  .psut_data = NULL,
  mat_colname,
  path,
  overwrite_file = FALSE,
  worksheet_names = NULL,
  overwrite_worksheets = FALSE,
  .wrote_mats_colname = "WroteMats",
  mat_bg_color = openxlsx2::wb_color(hex = "D9D9D9")
)
}
\arguments{
\item{.psut_data}{A \code{matsindf}-style data frame.}

\item{mat_colname}{The name of a column in \code{.psut_data} containing matrices.}

\item{path}{The path to which the Excel file will be saved.}

\item{overwrite_file}{A boolean that tells whether to overwrite an existing file at \code{path}.}

\item{worksheet_names}{The name of a column in \code{.psut_data} containing names of worksheets.}

\item{overwrite_worksheets}{A boolean that tells whether to overwrite worksheets in an existing file at \code{path}.}

\item{.wrote_mats_colname}{The name of the outgoing column
that tells whether a worksheet was written successfully.
Default is "WroteMats".}

\item{mat_bg_color}{The background color for numerical cells in the matrices.}
}
\value{
The wbWorkbook object that was saved (the result of \code{openxlsx2::wb_save()}),
invisibly.
}
\description{
It is often useful to write matrices from a \code{matsindf}-style data frame
into an Excel file for viewing.
This function writes one matrix to each tab of the specified file.
Tabs are named by the column specified in \code{worksheet_names}.
}
\examples{
\dontrun{
  # Create a simple matrix
  mat <- matrix(1:6, nrow = 3, ncol = 2,
                dimnames = list(c("r1", "r2", "r3"),
                                c("c1", "c2")))
  # Create a matsindf data frame
  df <- tibble::tibble(mat = list(mat, mat+1, mat+2),
                       worksheet_name = c("A", "B", "C"))
  # Create a temporary file
  mat_temp_path <- tempfile(pattern = "write_mat_to_excel_test_file",
                            fileext = ".xlsx")
  # Write the file.
  df |>
    write_mats_to_excel(mat_colname = "mat",
                        worksheet_names = "worksheet_name",
                        path = mat_temp_path,
                        overwrite_file = TRUE)
  # Check the appearance
  openxlsx2::wb_open(mat_wb)
  if (file.exists(mat_temp_path)) {
    res <- file.remove(mat_temp_path)
  }
}
}
