% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Utilities.R
\name{rename_via_pattern_byname}
\alias{rename_via_pattern_byname}
\title{Rename row or column names via regexp pattern}
\usage{
rename_via_pattern_byname(
  a,
  margin = list(c(1, 2)),
  regexp_pattern = "$^",
  replacement,
  pieces = "all",
  prepositions = RCLabels::prepositions_list,
  notation = RCLabels::bracket_notation,
  ...
)
}
\arguments{
\item{a}{A matrix or list of matrices.}

\item{margin}{The margin on which replacements are performed.
Default is \code{c(1, 2)}, meaning both
row (\code{1}) and column (\code{2}) names will be replaced.}

\item{regexp_pattern}{The regular expression pattern that will be replaced
in the row or column labels.
Default is "$^", meaning nothing will be matched.}

\item{replacement}{The string to replace the \code{regexp_pattern}.}

\item{pieces}{The pieces of labels to be searched for \code{regexp_pattern}.
See \link[RCLabels:regex_funcs]{RCLabels::replace_by_pattern} for details.
Default is "all".}

\item{prepositions}{Prepositions to use while searching for
\code{pieces}.
Default is \link[RCLabels:prepositions_list]{RCLabels::prepositions_list}.}

\item{notation}{The notation used for for searching \code{pieces}.
Default is \link[RCLabels:bracket_notation]{RCLabels::bracket_notation}.}

\item{...}{Other arguments passed to \code{\link[=gsub]{gsub()}},
such as \code{ignore.case}, \code{perl}, \code{fixed},
or \code{useBytes}.
Arguments in \code{...} apply to all matrices
in \code{a}.
See examples.}
}
\value{
A modified version of \code{a}.
}
\description{
It is sometimes helpful to rename row or column names
for a list of matrices via a \code{regexp_pattern}.
When \code{a} is a matrix or a list of matrices,
\code{regexp_pattern} indicates which characters
are replaced by \code{replacement}.
}
\details{
Note that \code{margin} can be a rowtype or coltype string
which will be de-referenced to the integer margin
(\code{1} for rows or \code{2} for columns).

Internally, this function calls \link[RCLabels:regex_funcs]{RCLabels::replace_by_pattern}.
}
\examples{
ma <- matrix(c(1, 2), nrow = 2,
             dimnames = list(c("Natural gas [from Supply]",
                               "row2"), 
                             "col")) |> 
  setrowtype("Product") |> setcoltype("Industry")
mb <- matrix(c(1, 2), nrow = 2,
             dimnames = list(c("Natural gas [from Supply]",
                               "Fuel oil [from Supply]"), 
                             "col")) |> 
  setrowtype("Product") |> setcoltype("Industry")
ma |> 
  rename_via_pattern_byname(regexp_pattern = " [from Supply]",
                            replacement = " bogus", 
                            fixed = TRUE)
list(ma, mb) |> 
  rename_via_pattern_byname(margin = 1,
                            regexp_pattern = " [from Supply]",
                            replacement = " from Supply", 
                            fixed = TRUE)
res1 <- tibble::tibble(m = list(ma, mb)) |> 
  dplyr::mutate(
    m1 = .data[["m"]] |> 
      rename_via_pattern_byname(regexp_pattern = " [from Supply]", 
                                replacement = "", 
                                fixed = TRUE)
  )
res1$m1
# Transpose mb and use a string for the margin.
# The string (in this case "Product")
# is dereferenced to an integer margin.
# In this case, the rownames of the first matrix
# and the colnames of the second matrix are replaced,
# because those are on the "Product" margin.
res2 <- tibble::tibble(m = list(ma, 
                                transpose_byname(mb))) |> 
  dplyr::mutate(
    m2 = .data[["m"]] |> 
      rename_via_pattern_byname(margin = "Product", 
                                regexp_pattern = " [from Supply]", 
                                replacement = "", 
                                fixed = TRUE)
  )
rowtype(res2$m2[[1]])
coltype(res2$m2[[2]])
res2$m2
}
