% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Utilities.R
\name{rename_to_pref_suff_byname}
\alias{rename_to_pref_suff_byname}
\title{Rename matrix rows and columns by prefix and suffix}
\usage{
rename_to_pref_suff_byname(a, keep, margin = c(1, 2), notation)
}
\arguments{
\item{a}{a matrix or list of matrices whose rows or columns will be renamed.}

\item{keep}{one of "prefix" or "suffix" indicating which part of the row or column name to retain.}

\item{margin}{one of \code{1}, \code{2}, or \code{c(1, 2)} where \code{1} indicates rows and \code{2} indicates columns.}

\item{notation}{See \code{notation_vec()}.}
}
\value{
\code{a} with potentially different row or column names.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#superseded}{\figure{lifecycle-superseded.svg}{options: alt='[Superseded]'}}}{\strong{[Superseded]}}
It can be convenient to rename rows or columns of matrices
based on retaining prefixes or suffixes.
This function provides that capability.
}
\details{
A prefix is defined by an opening string (\code{prefix_open}) and a closing string (\code{prefix_close}).
A suffix is defined by an opening string (\code{suffix_open}) and a closing string (\code{suffix_close}).
If \code{sep} is provided and none of \code{prefix_open}, \code{prefix_close}, \code{suffix_open}, and \code{suffix_close} are provided,
default arguments become:
* \code{prefix_open}: "",
* \code{prefix_close}: \code{sep},
* \code{suffix_open}: \code{sep}, and
* \code{suffix_close}: "".

The \code{keep} parameter tells which portion to retain (prefixes or suffixes),

If prefixes or suffixes are not found in a row and/or column name, that name is unchanged.
}
\examples{
# This function is superseded. 
# Instead, use `rename_to_piece_byname()`.
# For example:
m <- matrix(c(1, 2, 
              3, 4, 
              5, 6), nrow = 3, byrow = TRUE, 
            dimnames = list(c("a -> b", "r2", "r3"), c("a -> b", "c -> d")))
m
rename_to_piece_byname(m, piece = "pref", notation = RCLabels::arrow_notation)
# Note, labels are lost, because some labels are missing a suffix.
rename_to_piece_byname(m, piece = "suff", notation = RCLabels::arrow_notation)
# Original documentation:
rename_to_pref_suff_byname(m, keep = "pref", notation = RCLabels::arrow_notation)
rename_to_pref_suff_byname(m, keep = "suff", notation = RCLabels::arrow_notation)
}
