% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/batch.R
\name{process_batch_citation}
\alias{process_batch_citation}
\title{Process Multiple BibTeX Citations and Update Literature Matrix}
\usage{
process_batch_citation(.data, citations, where = NULL)
}
\arguments{
\item{.data}{A data frame containing at least three columns:
\itemize{
  \item citation: Character column for formatted citations
  \item keywords: List column for citation keywords
  \item year: Numeric column for publication years
}}

\item{citations}{Character vector of file paths to BibTeX citation files}

\item{where}{Numeric vector indicating which rows to update. If NULL (default),
all rows will be updated.}
}
\value{
A data frame with updated citation information in the specified rows
}
\description{
Reads multiple BibTeX citations from files and updates the corresponding rows in a
literature matrix with formatted citations, keywords, and years.
}
\seealso{
\code{\link{format_batch_ama_citation}}, \code{\link{parse_batch_citation}}
}
