% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classic_style.R
\name{classic_style}
\alias{classic_style}
\title{Classic styling for markdown}
\usage{
classic_style(
  base_size = 12,
  body_font = "",
  header_font = "",
  code_font = "mono",
  ...,
  ltr = TRUE
)
}
\arguments{
\item{base_size}{The base font size for the text. All other sizing is based
on this}

\item{body_font}{The font family to use for body text}

\item{header_font}{The font family to use for headers}

\item{code_font}{The font family to use for code and code block text}

\item{...}{
  Arguments passed on to \code{\link[=base_style]{base_style}}
  \describe{
    \item{\code{weight}}{The font weight to use. Can either be a number (\code{0}, \code{100},
\code{200}, \code{300}, \code{400}, \code{500}, \code{600}, \code{700}, \code{800}, or \code{900}) or a strings
(\code{"undefined"}, \code{"thin"}, \code{"ultralight"}, \code{"light"}, \code{"normal"}, \code{"medium"},
\code{"semibold"}, \code{"bold"}, \code{"ultrabold"}, or \code{"heavy"})}
    \item{\code{italic}}{Should the font be slanted}
    \item{\code{width}}{The font width to use. Can either be a number (``0\verb{, }1`, `2`,
`3`, `4`, `5`, `6`, `7`, `8`, or `9`) or strings (`"undefined"`,
`"ultracondensed"`, `"extracondensed"`, `"condensed"`, `"semicondensed"`,
`"normal"`, `"semiexpanded"`, `"expanded"`, `"extraexpanded"`, or
`"ultraexpanded"`)}
    \item{\code{features}}{A \link[systemfonts:font_feature]{font_feature} object specifying
any OpenType font features to apply to the font}
    \item{\code{color}}{Is the color of the font}
    \item{\code{lineheight}}{The spacing between subsequent lines relative to the font
size. Can be \code{\link[=relative]{relative()}} in which case it is based on the parent lineheight.}
    \item{\code{align}}{The alignment within the text. One of \code{"left"}, \code{"center"},
\code{"right"}, \code{"justified-left"}, \code{"justified-center"}, \code{"justified-right"}, or
\code{"distributed"}}
    \item{\code{tracking}}{Additional character spacing measured in 1/1000em. Can be
\code{\link[=relative]{relative()}} in which case it is based on the parent tracking.}
    \item{\code{indent}}{The indentation of the first line in a paragraph measured in
points. Can be \code{\link[=relative]{relative()}} in which case it is based on the parent indent,
\code{\link[=em]{em()}} in which case it is based on the font size in this style, or \code{\link[=rem]{rem()}}
in which case it is based on the font size of the body element.}
    \item{\code{hanging}}{The indentation of all but the first line in a paragraph
measured in points. Can be \code{\link[=relative]{relative()}} in which case it is based on the
parent hanging, \code{\link[=em]{em()}} in which case it is based on the font size in this
style, or \code{\link[=rem]{rem()}} in which case it is based on the font size of the body
element.}
    \item{\code{margin}}{The margin around the element, given as a call to \code{\link[=trbl]{trbl()}}.
Margin refers to the area outside the box that text is placed in. If the
element has a background, the margin area will not be colored.}
    \item{\code{padding}}{The padding around the element, given as a call to \code{\link[=trbl]{trbl()}}.
Padding refers to the distance between the text and the border of the box it
will be drawn in. If the element has a background, the padding area will be
colored.}
    \item{\code{background}}{The color of the background fill. The background includes
the padding but not the margin. Can be a solid color or a gradient or pattern
made with \code{grid::linearGradient()}/\code{grid::radialGradient()}/\code{grid::pattern()}}
    \item{\code{border}}{The color of the background stroke. The background includes
the padding but not the margin}
    \item{\code{border_width}}{The line width of the background stroke, given as a call
to \code{\link[=trbl]{trbl()}}}
    \item{\code{border_type}}{The linetype of the background stroke, given as an an
\code{lty} compatible value (See the \emph{Line Type Specification} section in
\link[graphics:par]{par})}
    \item{\code{border_radius}}{The corner radius of the background, given in points}
    \item{\code{outline}}{The color of the outline stroke.}
    \item{\code{outline_width}}{The line width of the outline stroke.}
    \item{\code{outline_type}}{The linetype of the outline stroke, given as an an
\code{lty} compatible value (See the \emph{Line Type Specification} section in
\link[graphics:par]{par})}
    \item{\code{outline_join}}{The line join type for the outline. Either \code{"round"},
\code{"mitre"}, or \code{"bevel"}.}
    \item{\code{outline_mitre}}{The mitre limit (relative distance between inner and
outer corner at a join) if \code{outline_join = "mitre"}.}
    \item{\code{bullets}}{A vector of strings to use for bullets in unordered lists.
\code{marquee_bullets} provides a selection}
    \item{\code{underline}}{Should text be underlined}
    \item{\code{strikethrough}}{Should text be strikethrough}
    \item{\code{baseline}}{The baseline shift to apply to the text}
    \item{\code{img_asp}}{The default aspect ratio for block level images if not
provided by the image itself}
    \item{\code{text_direction}}{The directional flow of the text. Either \code{"auto"} to
let it be determined by the content of the text, or \code{"ltr"}/\code{"rtl"} to
hard-code it to either left-to-right or right-to-left. This setting will not
change the order of glyphs within a span of text, but rather whether
consequtive blocks of text are laid out left-to-right or right-to-left. It
also affects to which side indentation is applied as well as the meaning of
\code{"auto"}, and \code{"justified-auto"} aligment.}
    \item{\code{border_size}}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} Use \code{border_width}
instead}
  }}

\item{ltr}{Is the style intended for left-to-right text? This affects list
indentation and citation border}
}
\value{
A style set object
}
\description{
This function facilitates construction of a complete style set based on the
classic look of an HTML rendered markdown document. It contains style
specifications for all the supported markdown elements as well as a \code{sub} and
\code{sup} style that can be used for subscripts and superscript respectively.
These are only accessible through custom spans (e.g. \verb{H\{.sub 2\}O}) as
markdown doesn't provide a syntax for these formats.
}
\examples{
classic_style(16, "serif", "sans")

}
