% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.mc.R
\name{plot.mc}
\alias{plot.mc}
\title{Plot Mark Correlation Function Objects}
\usage{
\method{plot}{mc}(
  x,
  which_marks = NULL,
  which_points = NULL,
  layers = list(),
  xlab = "Distance r",
  ylab = "Mark correlation",
  ...
)
}
\arguments{
\item{x}{An object of class `mc`.}

\item{which_marks}{For global or local multi-mark objects: character or numeric vector specifying which marks to plot. Default `NULL` (all marks).}

\item{which_points}{For local MC objects: numeric or character vector specifying which points to overlay. Default `NULL` (all points).}

\item{layers}{A list of additional ggplot2 layers (themes, labs, scales, etc.) to add to the plot.}

\item{xlab}{Label for x-axis (default "Distance r").}

\item{ylab}{Label for y-axis (default "Mark correlation").}

\item{...}{Additional arguments passed to `geom_line()`.}
}
\value{
Invisibly returns the ggplot object.
}
\description{
Plots objects of class `mc` (mark correlation functions).
Supports global and local types, multiple marks, and fully customizable appearance via `layers` or `...`.
}
\section{Additional graphical customization}{

The object returned by \code{plot.testmc()} is a \code{ggplot} object. This means
that all standard graphical components from the \pkg{ggplot2} package (such as
layers, scales, and themes) can be added to the plot using the \code{+} operator.
This allows users to further customize labels, colors, axes, and the overall
appearance of the plot.
}

\examples{
\donttest{

 library(spatstat.geom)
 library(spatstat.random)
 library(spatstat.explore)
 library(spatstat.linnet)
 library(ggplot2)

# --- Example 1: Single mark --------------------------------------------

X1 <- rpoispp(100)
marks(X1) <- cbind(m1 = runif(npoints(X1), 1, 10))

mc1 <- mcorr.ppp(X1, ftype = "stoyan", method = "density")

plot(mc1) +
  labs(
    title = "Mark correlation for a single mark",
    x = expression(r),
    y = "Correlation"
  ) +
  theme_minimal() +
  theme(
    plot.title = element_text(size = 14, face = "bold"),
    axis.title = element_text(size = 12),
    axis.text  = element_text(size = 10),
    legend.title = element_text(size = 11),
    legend.text  = element_text(size = 10)
  )


# --- Example 2: Two marks ----------------------------------------------

X2 <- rpoispp(100)
marks(X2) <- cbind(
  m1 = runif(npoints(X2), 1, 10),
  m2 = runif(npoints(X2), 1, 10)
)

mc2 <- mcorr.ppp(X2, ftype = "stoyan", method = "density")

# Plot both marks
plot(mc2) +
  labs(
    title = "Mark correlation for two marks",
    x = expression(r),
    y = "Correlation"
  ) +
  theme_bw() +
  theme(
    plot.title = element_text(size = 14, face = "bold"),
    axis.title = element_text(size = 12),
    axis.text  = element_text(size = 10),
    legend.title = element_text(size = 11),
    legend.text  = element_text(size = 10),
    legend.position = "top"
  )

# Plot only mark m1
plot(mc2, which_marks = "m1") +
  labs(
    title = "Mark correlation for mark m1 only",
    x = expression(r),
    y = "Correlation"
  ) +
  theme_minimal() +
  theme(
    plot.title = element_text(size = 14, face = "bold"),
    axis.title = element_text(size = 12),
    axis.text  = element_text(size = 10),
    legend.position = "none"
  )


# --- Example 3: Local mark correlation ---------------------------------

lc1 <- lmcorr.ppp(X2, ftype = "stoyan", method = "density")

# Two selected points, mark m1
plot(lc1, which_points = 1:2, which_marks = "m1") +
  labs(
    title = "Local mark correlation (points 1–2, mark m1)",
    x = expression(r),
    y = "Local correlation"
  ) +
  theme_classic() +
  theme(
    plot.title = element_text(size = 13, face = "bold"),
    axis.title = element_text(size = 12),
    axis.text  = element_text(size = 10),
    legend.title = element_text(size = 11),
    legend.text  = element_text(size = 10),
    legend.position = "right"
  )

# Single selected point
plot(lc1, which_points = 1) +
  labs(
    title = "Local mark correlation (single selected point)",
    x = expression(r),
    y = "Local correlation"
  ) +
  theme_light() +
  theme(
    plot.title = element_text(size = 13, face = "bold"),
    axis.title = element_text(size = 12),
    axis.text  = element_text(size = 10),
    legend.position = "bottom"
  )

}
}
\author{
Mehdi Moradi \email{m2.moradi@yahoo.com}
}
