% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/within.R
\name{within}
\alias{within}
\alias{between}
\alias{betwee_more}
\alias{between_more}
\title{within boundaries}
\usage{
between_more(x, left, right, type = c("gele", "gel", "gle", "gl"))

within(x, left = NULL, right = NULL, bounds = c("[]", "[)", "(]", "()"))
}
\arguments{
\item{x}{A numeric vector of values}

\item{left, right}{Boundary values.  For \code{\link[=within]{within()}}, when \code{NULL} no
comparison is made for that boundary.  When both are \code{NULL}, \code{x} is just
returned.}

\item{type}{Abbreviation for the evaluation of \code{left} on \code{right} (see
details)}

\item{bounds}{Boundaries for comparisons of \code{left} and \code{right} (see details)}
}
\value{
A logical vector
}
\description{
Compare a vector within (between) other values
}
\details{
\verb{type``, }bounds`` can be one of the below:

\describe{
\item{g,(}{is greater than (>)}
\item{ge,[}{greater than or equal to (>=)}
\item{l,))}{less than (<)}
\item{le,[]}{less than or equal to (<=)}
}

Note: \code{\link[=between_more]{between_more()}} may be deprecated in the future in favor of just
\code{\link[=within]{within()}}
}
\examples{

between_more(2:10, 2, 10, "gl")
within(2:10, 2, bounds = "()")
between_more(10, 2, 10, "gle")
within(2:10, bounds = "(]")
within(1:5, c(3, 3, 2, 2, 1), 5)
}
