% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pairwise_rf.R
\name{est_pairwise_rf}
\alias{est_pairwise_rf}
\title{Pairwise two-point analysis}
\usage{
est_pairwise_rf(
  input.seq,
  count.cache = NULL,
  count.matrix = NULL,
  ncpus = 1L,
  mrk.pairs = NULL,
  n.batches = 1L,
  est.type = c("disc", "prob"),
  verbose = TRUE,
  memory.warning = TRUE,
  parallelization.type = c("PSOCK", "FORK"),
  tol = .Machine$double.eps^0.25,
  ll = FALSE
)
}
\arguments{
\item{input.seq}{an object of class \code{mappoly.sequence}}

\item{count.cache}{an object of class \code{cache.info} containing
pre-computed genotype frequencies, obtained with
\code{\link[mappoly]{cache_counts_twopt}}. If \code{NULL} (default),
genotype frequencies are internally loaded.}

\item{count.matrix}{similar to \code{count.cache}, but in matrix format. 
Mostly for internal use.}

\item{ncpus}{Number of parallel processes (cores) to spawn (default = 1)}

\item{mrk.pairs}{a matrix of dimensions 2*N, containing N
pairs of markers to be analyzed. If \code{NULL} (default), all pairs are
considered}

\item{n.batches}{deprecated. Not available on MAPpoly 0.3.0 or higher}

\item{est.type}{Indicates whether to use the discrete ("disc") or the probabilistic ("prob") dosage scoring 
when estimating the two-point recombination fractions.}

\item{verbose}{If \code{TRUE} (default), current progress is shown; if
\code{FALSE}, no output is produced}

\item{memory.warning}{if \code{TRUE}, prints a memory warning if the 
number of markers is greater than 10000 for ploidy levels up to 4, and 
3000 for ploidy levels > 4.}

\item{parallelization.type}{one of the supported cluster types. This should 
be either PSOCK (default) or FORK.}

\item{tol}{the desired accuracy. See \code{optimize()} for details}

\item{ll}{will return log-likelihood instead of LOD scores. 
(for internal use)}
}
\value{
An object of class \code{mappoly.twopt} which is a list containing the following components:
\describe{
  \item{\code{data.name}}{Name of the object of class \code{mappoly.data} containing the raw data.}
  \item{\code{n.mrk}}{Number of markers in the sequence.}
  \item{\code{seq.num}}{A \code{vector} containing the (ordered) indices of markers in the sequence, according to the input file.}
  \item{\code{pairwise}}{A list of size \code{choose(length(input.seq$seq.num), 2)}, where each element is a matrix. The rows are named in the format x-y, where x and y indicate how many homologues share the same allelic variant in parents P and Q, respectively (see Mollinari and Garcia, 2019 for notation). The first column indicates the LOD Score for the most likely linkage phase configuration. The second column shows the estimated recombination fraction for each configuration, and the third column indicates the LOD Score for comparing the likelihood under no linkage (r = 0.5) with the estimated recombination fraction (evidence of linkage).}
  \item{\code{chisq.pval.thres}}{Threshold used to perform the segregation tests.}
  \item{\code{chisq.pval}}{P-values associated with the performed segregation tests.}
}
}
\description{
Performs the two-point pairwise analysis between all markers in a sequence. 
For each pair, the function estimates the recombination fraction for all 
possible linkage phase configurations and associated LOD Scores.
}
\examples{
  ## Tetraploid example (first 50 markers) 
  all.mrk <- make_seq_mappoly(tetra.solcap, 1:50)
  red.mrk <- elim_redundant(all.mrk)
  unique.mrks <- make_seq_mappoly(red.mrk)
  all.pairs <- est_pairwise_rf(input.seq = unique.mrks,
                               ncpus = 1, 
                               verbose = TRUE)
   all.pairs
   plot(all.pairs, 20, 21)
   mat <- rf_list_to_matrix(all.pairs)
   plot(mat)
}
\references{
Mollinari, M., and Garcia, A.  A. F. (2019) Linkage
    analysis and haplotype phasing in experimental autopolyploid
    populations with high ploidy level using hidden Markov
    models, _G3: Genes, Genomes, Genetics_. 
    \doi{10.1534/g3.119.400378}
}
\author{
Marcelo Mollinari, \email{mmollin@ncsu.edu}
}
