% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eliminate_redundant.R
\name{elim_redundant}
\alias{elim_redundant}
\title{Eliminate redundant markers}
\usage{
elim_redundant(input.seq, data = NULL)
}
\arguments{
\item{input.seq}{an object of class \code{mappoly.sequence}}

\item{data}{name of the dataset that contains sequence markers (optional, default = NULL)}
}
\value{
An object of class \code{mappoly.unique.seq} which
    is a list  containing the following components:
    \item{unique.seq}{an object of class \code{mappoly.sequence}
          with the redundant markers removed}
    \item{kept}{a vector containing the name of the informative markers}
    \item{eliminated}{a vector containing the name of the non-informative (eliminated) markers}
}
\description{
Eliminate markers with identical dosage information for all individuals.
}
\examples{
    all.mrk <- make_seq_mappoly(hexafake, 'all')
    red.mrk <- elim_redundant(all.mrk)
    plot(red.mrk)
    unique.mrks <- make_seq_mappoly(red.mrk)
   
}
\references{
Mollinari, M., and Garcia, A.  A. F. (2019) Linkage
    analysis and haplotype phasing in experimental autopolyploid
    populations with high ploidy level using hidden Markov
    models, _G3: Genes, Genomes, Genetics_. 
    \doi{10.1534/g3.119.400378}
}
\author{
Marcelo Mollinari, \email{mmollin@ncsu.edu}, with minor modifications by Gabriel Gesteira, \email{gdesiqu@ncsu.edu}
}
