% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_layer_mesh.R
\name{add_mesh}
\alias{add_mesh}
\title{Add Mesh}
\usage{
add_mesh(
  map,
  data = get_map_data(map),
  fill_opacity = NULL,
  elevation = NULL,
  tooltip = NULL,
  auto_highlight = FALSE,
  highlight_colour = "#AAFFFFFF",
  light_settings = list(),
  layer_id = NULL,
  id = NULL,
  palette = "viridis",
  na_colour = "#808080FF",
  legend = FALSE,
  legend_options = NULL,
  legend_format = NULL,
  update_view = TRUE,
  focus_layer = FALSE,
  digits = 6,
  transitions = NULL,
  brush_radius = NULL
)
}
\arguments{
\item{map}{a mapdeck map object}

\item{data}{data to be used in the layer. All coordinates are expected to be
EPSG:4326 (WGS 84) coordinate system}

\item{fill_opacity}{Either a string specifying the column of \code{data}
containing the opacity of each shape, or a single value in [0,255], or [0, 1),
to be applied to all the shapes. Default 255. If a hex-string is used as the
colour, this argument is ignored and you should include the alpha on the hex string}

\item{elevation}{the height the polygon extrudes from the map. Only available if neither
\code{stroke_colour} or \code{stroke_width} are supplied. Default 0}

\item{tooltip}{variable of \code{data} containing text or HTML to render as a tooltip}

\item{auto_highlight}{logical indicating if the shape under the mouse should auto-highlight}

\item{highlight_colour}{hex string colour to use for highlighting. Must contain the alpha component.}

\item{light_settings}{list of light setting parameters. See \link{light_settings}}

\item{layer_id}{single value specifying an id for the layer. Use this value to
distinguish between shape layers of the same type. Layers with the same id are likely
to conflict and not plot correctly}

\item{id}{an id value in \code{data} to identify layers when interacting in Shiny apps.}

\item{palette}{string or matrix. String will be one of \code{colourvalues::colour_palettes()}.
A matrix must have at least 5 rows, and 3 or 4 columns of values between [0, 255],
where the 4th column represents the alpha. You can use a named list to specify a different
palette for different colour options (where available),
 e.g. list(fill_colour = "viridis", stroke_colour = "inferno")}

\item{na_colour}{hex string colour to use for NA values}

\item{legend}{either a logical indiciating if the legend(s) should be displayed, or
a named list indicating which colour attributes should be included in the legend.}

\item{legend_options}{A list of options for controlling the legend.}

\item{legend_format}{A list containing functions to apply to legend values. See section legend}

\item{update_view}{logical indicating if the map should update the bounds to include this layer}

\item{focus_layer}{logical indicating if the map should update the bounds to only include this layer}

\item{digits}{number of digits for rounding coordinates}

\item{transitions}{list specifying the duration of transitions.}

\item{brush_radius}{radius of the brush in metres. Default NULL. If supplied,
the arcs will only show if the origin or destination are within the radius of the mouse.
If NULL, all arcs are displayed}
}
\description{
Adds polygons to the map from a \code{mesh3d} object
}
\details{
\code{add_mesh} supports mesh3d objects
}
\section{legend}{


The \code{legend_options} can be used to control the appearance of the legend.
This should be a named list, where the names are one of
\itemize{
  \item{css - a string of valid \code{css} for controlling the appearance of the legend}
  \item{title - a string to use for the title of the legend}
  \item{digits - number to round the legend values to}
}

If the layer allows different fill and stroke colours, you can use different options for each. See examples in \link{add_arc}.

The \code{legend_format} can be used to control the format of the values in the legend.
This should be a named list, where the names are one of
\itemize{
  \item{fill_colour}
  \item{stroke_colour}
}

depending on which type of colouring the layer supports.

The list elements must be functions to apply to the values in the legend.
}

\section{id}{


The \code{id} is returned to your R session from an interactive shiny environment
by observing layer clicks. This is useful for returning the data.frame row relating to the
cliked shape.

From within a shiny server you would typically use \code{ observeEvent({input$map_arc_click})},
where 'map' is the map_id supplied to \code{mapdeckOutput()}, and 'arc' is the layer
you are clicking on
}

\examples{
\donttest{

## exaggerate the elevation slightly
m <- melbourne_mesh
m$vb[3, ] <- m$vb[3, ] * 50

mapdeck() \%>\%
 add_mesh(
 data = m
 )

}

}
