% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_states.R
\name{generate_states}
\alias{generate_states}
\alias{syllabise_states}
\alias{syllabize_states}
\title{Generate fictional country names}
\usage{
generate_states(n = 10, countries = NULL, short = FALSE)

syllabise_states(word)

syllabize_states(word)
}
\arguments{
\item{n}{Integer number of country names to generate
from a library of fictional country names.
Default is 10.}

\item{countries}{Optionally, a list of country names (string vector)
from which to identify the prevalence of modifiers.}

\item{short}{Logical whether to reference a list of shorter country names,
or to include longer alternative names as well.
Default is \code{FALSE}, meaning both shorter and longer names are used.}

\item{word}{One or more words (character vector) to split into syllable-like units.}
}
\value{
String vector of fictional country names
}
\description{
This function generates a vector of fictional country names.
While the generated names are designed to resemble real country names,
the results will not match (at least not exactly) country names from
the library provided.
Please note that the function is still \emph{experimental}.

Checks are included to ensure that the generated names
are unique, do not match any existing country names,
and avoid certain uncommon patterns such as ending on a preposition.

This function can be useful for creating fictional datasets
for testing, illustrative, or pedagogical purposes.
For example, it can be used in classroom exercises that rely on
invented country names, such as
in-class simulations of international relations or negotiation,
role-playing scenarios,
or mock data analysis tasks.
Using fictional country names helps avoid any unintended
bias or preconceptions associated with real countries.
Or they can be used in creative writing or game design.
The names might inspire fictional settings or entities
in stories, games, or other creative works.
Each name could inspire a unique culture, conflict, or mythology.
Writers could use them to kickstart short stories,
while game designers might build entire maps or quests around them.
}
\examples{
  generate_states(12)
  syllabise_states("Afghanistan")
  syllabise_states("Saint Pierre and Miquelon")
}
