% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/measure_features.R
\name{measure_periods}
\alias{measure_periods}
\alias{net_waves}
\alias{net_change}
\alias{net_stability}
\alias{net_correlation}
\title{Measures of network change}
\usage{
net_waves(.data)

net_change(.data, object2)

net_stability(.data, object2)

net_correlation(.data, object2)
}
\arguments{
\item{.data}{An object of a manynet-consistent class:
\itemize{
\item matrix (adjacency or incidence) from \code{{base}} R
\item edgelist, a data frame from \code{{base}} R or tibble from \code{{tibble}}
\item igraph, from the \code{{igraph}} package
\item network, from the \code{{network}} package
\item tbl_graph, from the \code{{tidygraph}} package
}}

\item{object2}{A network object.}
}
\description{
These functions measure certain topological features of networks:
\itemize{
\item \code{net_waves()} measures the number of waves in longitudinal network data.
\item \code{net_change()} measures the Hamming distance between two or more networks.
\item \code{net_stability()} measures the Jaccard index of stability between two or more networks.
\item \code{net_correlation()} measures the product-moment correlation between two networks.
}

These \verb{net_*()} functions return a numeric vector the length of the number
of networks minus one. E.g., the periods between waves.
}
\seealso{
Other measures: 
\code{\link{measure_attributes_nodes}},
\code{\link{measure_attributes_ties}},
\code{\link{measure_central_between}},
\code{\link{measure_central_close}},
\code{\link{measure_central_degree}},
\code{\link{measure_central_eigen}},
\code{\link{measure_closure}},
\code{\link{measure_cohesion}},
\code{\link{measure_diffusion_infection}},
\code{\link{measure_diffusion_net}},
\code{\link{measure_diffusion_node}},
\code{\link{measure_features}},
\code{\link{measure_heterogeneity}},
\code{\link{measure_hierarchy}},
\code{\link{measure_holes}},
\code{\link{measure_properties}},
\code{\link{member_diffusion}}
}
\concept{measures}
