% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/measure_hierarchy.R
\name{measure_hierarchy}
\alias{measure_hierarchy}
\alias{net_by_hierarchy}
\alias{net_connectedness}
\alias{net_efficiency}
\alias{net_upperbound}
\title{Graph theoretic dimensions of hierarchy}
\usage{
net_by_hierarchy(.data)

net_connectedness(.data)

net_efficiency(.data)

net_upperbound(.data)
}
\arguments{
\item{.data}{An object of a manynet-consistent class:
\itemize{
\item matrix (adjacency or incidence) from \code{{base}} R
\item edgelist, a data frame from \code{{base}} R or tibble from \code{{tibble}}
\item igraph, from the \code{{igraph}} package
\item network, from the \code{{network}} package
\item tbl_graph, from the \code{{tidygraph}} package
}}
}
\description{
These functions, together with \code{net_reciprocity()}, are used jointly to
measure how hierarchical a network is:
\itemize{
\item \code{net_connectedness()} measures the proportion of dyads in the network
that are reachable to one another,
or the degree to which network is a single component.
\item \code{net_efficiency()} measures the Krackhardt efficiency score.
\item \code{net_upperbound()} measures the Krackhardt (least) upper bound score.
}
}
\examples{
net_connectedness(ison_networkers)
1 - net_reciprocity(ison_networkers)
net_efficiency(ison_networkers)
net_upperbound(ison_networkers)
}
\references{
\subsection{On hierarchy}{

Krackhardt, David. 1994.
Graph theoretical dimensions of informal organizations.
In Carley and Prietula (eds) \emph{Computational Organizational Theory},
Hillsdale, NJ: Lawrence Erlbaum Associates. Pp. 89-111.

Everett, Martin, and David Krackhardt. 2012.
“A second look at Krackhardt's graph theoretical dimensions of informal organizations.”
\emph{Social Networks}, 34: 159-163.
\doi{10.1016/j.socnet.2011.10.006}
}
}
\seealso{
Other measures: 
\code{\link{measure_attributes_nodes}},
\code{\link{measure_attributes_ties}},
\code{\link{measure_central_between}},
\code{\link{measure_central_close}},
\code{\link{measure_central_degree}},
\code{\link{measure_central_eigen}},
\code{\link{measure_closure}},
\code{\link{measure_cohesion}},
\code{\link{measure_diffusion_infection}},
\code{\link{measure_diffusion_net}},
\code{\link{measure_diffusion_node}},
\code{\link{measure_features}},
\code{\link{measure_heterogeneity}},
\code{\link{measure_holes}},
\code{\link{measure_periods}},
\code{\link{measure_properties}},
\code{\link{member_diffusion}}
}
\concept{measures}
