% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/manip_reformed.R
\name{manip_paths}
\alias{manip_paths}
\alias{to_matching}
\alias{to_mentoring}
\alias{to_eulerian}
\alias{to_tree}
\alias{to_dominating}
\title{Modifying networks paths}
\usage{
to_matching(.data, mark = "type", capacities = NULL)

to_mentoring(.data, elites = 0.1)

to_eulerian(.data)

to_tree(.data)

to_dominating(.data, from, direction = c("out", "in"))
}
\arguments{
\item{.data}{An object of a manynet-consistent class:
\itemize{
\item matrix (adjacency or incidence) from \code{{base}} R
\item edgelist, a data frame from \code{{base}} R or tibble from \code{{tibble}}
\item igraph, from the \code{{igraph}} package
\item network, from the \code{{network}} package
\item tbl_graph, from the \code{{tidygraph}} package
}}

\item{mark}{A logical vector marking two types or modes.
By default "type".}

\item{capacities}{An integer or vector of integers the same length as the
nodes in the network that describes the maximum possible degree the node
can have in the matched network.}

\item{elites}{The proportion of nodes to be selected as mentors.
By default this is set at 0.1.
This means that the top 10\% of nodes in terms of degree,
or those equal to the highest rank degree in the network,
whichever is the higher, will be used to select the mentors.

Note that if nodes are equidistant from two mentors,
they will choose one at random.
If a node is without a path to a mentor,
for example because they are an isolate,
a tie to themselves (a loop) will be created instead.
Note that this is a different default behaviour than that
described in Valente and Davis (1999).}

\item{from}{The index or name of the node from which the path should be traced.}

\item{direction}{String, either "out" or "in".}
}
\value{
All \code{to_} functions return an object of the same class as that provided.
So passing it an igraph object will return an igraph object
and passing it a network object will return a network object,
with certain modifications as outlined for each function.
}
\description{
These functions return tidygraphs containing only special sets of ties:
\itemize{
\item \code{to_matching()} returns only the matching ties in some network data.
\item \code{to_mentoring()} returns only ties to nodes' closest mentors.
\item \code{to_eulerian()} returns only the Eulerian path within some network data.
\item \code{to_tree()} returns the spanning tree in some network data or,
if the data is unconnected, a forest of spanning trees.
\item \code{to_dominating()} returns the dominating tree of the network
}
}
\details{
Not all functions have methods available for all object classes.
Below are the currently implemented S3 methods:\tabular{lrrrrr}{
    \tab data.frame \tab igraph \tab matrix \tab network \tab tbl_graph \cr
   to_eulerian \tab 0 \tab 1 \tab 0 \tab 0 \tab 1 \cr
   to_matching \tab 1 \tab 1 \tab 1 \tab 1 \tab 1 \cr
   to_mentoring \tab 0 \tab 1 \tab 0 \tab 0 \tab 1 \cr
}
}
\section{\code{to_matching()}}{

This function attempts to solve the stable matching problem,
also known as the stable marriage problem, upon a given
two-mode network (or other network with a binary mark).

In the basic version,
\code{to_matching()} uses \code{igraph::max_bipartite_match()}
to return a network in which each node is only tied to
one of its previous ties.
The number of these ties left is its \emph{cardinality},
and the algorithm seeks to maximise this such that,
where possible, each node will be associated with just one
node in the other mode or some other mark.
The algorithm used is the push-relabel algorithm
with greedy initialization and a global relabelling
after every \eqn{\frac{n}{2}} steps,
where \eqn{n} is the number of nodes in the network.

In the more general version, each node may have a larger capacity,
or even different capacities.
Here an implementation of the Gale-Shapley algorithm is used,
in which an iterative process of proposal and acceptance is repeated until
all are matched or have exhausted their lists of preferences.
This is, however, computationally slower.
}

\examples{
to_matching(ison_southern_women)
  to_eulerian(delete_nodes(ison_koenigsberg, "Lomse"))
}
\references{
\subsection{On matching}{

Gale, David, and Lloyd Stowell Shapley. 1962.
"College admissions and the stability of marriage".
\emph{The American Mathematical Monthly}, 69(1): 9–14.
\doi{10.2307/2312726}

Goldberg, Andrew V., and Robert E. Tarjan. 1986.
"A new approach to the maximum flow problem".
\emph{Proceedings of the 18th Annual ACM Symposium on Theory of Computing}.
136-146.
\doi{10.1145/12130.12144}
}

\subsection{On mentoring}{

Valente, Thomas, and Rebecca Davis. 1999.
"Accelerating the Diffusion of Innovations Using Opinion Leaders",
\emph{Annals of the American Academy of Political and Social Science} 566: 56-67.
\doi{10.1177/000271629956600105}
}

\subsection{On Eulerian trails}{

Euler, Leonard. 1736.
"Solutio problematis ad geometriam situs pertinentis".
\emph{Comment. Academiae Sci. I. Petropolitanae} 8: 128–140.

Hierholzer, Carl. 1873.
"Ueber die Möglichkeit, einen Linienzug ohne Wiederholung und ohne Unterbrechung zu umfahren".
\emph{Mathematische Annalen}, 6(1): 30–32.
\doi{10.1007/BF01442866}
}

\subsection{On minimum spanning trees}{

Boruvka, Otakar. 1926.
"O jistem problemu minimalnim".
\emph{Prace Mor. Prirodoved. Spol. V Brne III} 3: 37-58.

Kruskal, Joseph B. 1956.
"On the shortest spanning subtree of a graph and the travelling salesman problem".
\emph{Proceedings of the American Mathematical Society} 7(1): 48-50.
\doi{10.1090/S0002-9939-1956-0078686-7}

Prim, R.C. 1957.
"Shortest connection networks and some generalizations".
\emph{Bell System Technical Journal} 36(6):1389-1401.
\doi{10.1002/j.1538-7305.1957.tb01515.x}
}
}
\seealso{
Other modifications: 
\code{\link{manip_as}},
\code{\link{manip_correlation}},
\code{\link{manip_deformat}},
\code{\link{manip_direction}},
\code{\link{manip_from}},
\code{\link{manip_levels}},
\code{\link{manip_miss}},
\code{\link{manip_nodes}},
\code{\link{manip_permutation}},
\code{\link{manip_preformat}},
\code{\link{manip_project}},
\code{\link{manip_reformat}},
\code{\link{manip_scope}},
\code{\link{manip_split}},
\code{\link{manip_ties}}
}
\concept{modifications}
