% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_var_corr_.R
\name{get_var_corr_}
\alias{get_var_corr_}
\title{Get correlations for combinations}
\usage{
get_var_corr_(
  df,
  subset_cols = NULL,
  drop_columns = c("character", "factor"),
  ...
)
}
\arguments{
\item{df}{A `data.frame` object for which correlations are required in combinations.}

\item{subset_cols}{A `list` of length 2. The values in the list correspond to the comparison
and other_Var arguments in `get_var_corr`. See examples below.}

\item{drop_columns}{A character vector specifying column classes to drop. Defaults to
c("factor","character")}

\item{...}{Other arguments to `get_var_corr`}
}
\value{
A data.frame object with combinations.
}
\description{
Get correlations for combinations
}
\details{
This function extends get_var_corr by providing an opportunity to get correlations
for combinations of variables. It is currently slow and may take up to a minute depending on system specifications.
}
\examples{
get_var_corr_(mtcars,method="pearson")
#use only a subset of the data.
 get_var_corr_(mtcars,
             subset_cols = list(c("mpg","vs"),
                                c("disp","wt")),
             method="spearman",exact=FALSE)
}
