% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_register.R
\name{make_register}
\alias{make_register}
\title{Register objects to be returned from \code{make_with_source}}
\usage{
make_register(value, name, quiet = FALSE)
}
\arguments{
\item{value}{A value to be registered in a source script and returned as part
of the \code{Segment}}

\item{name}{A variable name, given as a character string. No coercion is
done, and the first element of a character vector of length greater than
one will be used, with a warning.}

\item{quiet}{A logical determining whether or not warnings are signaled when
\code{make_register()} is called outside of a 'makepipe' pipeline}
}
\value{
\code{value} invisibly
}
\description{
It is sometimes useful to have access to certain objects which are generated as
side-products in a source script which yields as a main-product one or more
targets. Typically these objects are used for checking that the targets were
produced as expected.
}
\examples{

\dontrun{
  # Imagine this is part of your source script:
  x <- readRDS("input.Rds")
  x <- do_stuff(x)
  chk <- do_check(x)
  make_register(chk, "x_check")
  saveRDS(x, "output.Rds")

  # You will have access to `chk` in your pipeline script:
  step_one <- make_with_source(
    "source.R",
    "output.Rds",
    "input.Rds",
  )
  step_one$result$chk
}
}
