% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update-special.R
\name{updateMatrix}
\alias{updateMatrix}
\title{A matrix-specific wrapper of \code{\link{updateValues}}}
\usage{
updateMatrix(
  target,
  projectName,
  modelName,
  attributeName,
  matrix,
  autolink = FALSE,
  dryRun = FALSE,
  separator = ",",
  auto.proceed = FALSE,
  revisions.only = FALSE,
  template = NULL,
  ...
)
}
\arguments{
\item{target}{A list, which can be created using \code{\link{magmaRset}}, containing your authorization 'token' (a string), a 'url' of magma to target (a string), and optional 'opts' for specifying additions parameters for curl requests (a named list).}

\item{projectName}{Single string. The name of the project you would like to interact with. For options, see \code{\link{retrieveProjects}}.}

\item{modelName}{Single string. The name of the subset data structure within the project, which are referred to as 'model's in magma, to interact with.
For options, see \code{\link{retrieveModels}} or https://timur.ucsf.edu/<projectName>/map.}

\item{attributeName}{String naming the matrix attribute for which to upload data.}

\item{matrix}{A matrix or dataframe containing the data to upload to magma.

Alternatively, a String specifying the file path of a file containing such data.

No matter the provision method, colnames must be record identifiers, and rownames should match the values of 'options' associated with the target 'attribute'.
Check the 'See Also' section below for how to determine the needed 'options'.}

\item{autolink}{Logical. FALSE by default for safety, but often you will want to set it to TRUE. Passed through to magma, this parameter controls whether the system will attempt to connect all targeted records up with the project's root.
Specifically, this means the system will 
1) determine parent records of all targeted records if it can, based on the project's gnomon grammar, 
2) continue parent determination for those parent records, repeating this process until reaching the project's root (the project record),
then 3) creates any of these records that don't currently exist,
and finally 4) creates all the assumed parent-child linkages}

\item{dryRun}{Logical. FALSE by default. Passed through to magma, this parameter controls whether the system will only test whether the update is valid without making changes to the database.}

\item{separator}{String indicating the field separator to use if providing \code{matrix} as a file path.
Default = \code{","}.}

\item{auto.proceed}{Logical. When set to TRUE, the function does not ask before proceeding forward with the 'magma/update'.}

\item{revisions.only}{Logical. For troubleshooting purposes, when set to \code{TRUE}, no data will be sent to magma.
Instead, the list structure that would have been passed to the \code{revisions} input of \code{\link{updateValues}} is returned as output.}

\item{template}{For internal use in minimizing excess http requests to magma, NULL or the return of \code{retrieveTemplate(target, projectName)}.}

\item{...}{Additional parameters passed along to the internal `.retrieve()`, `.query()`, or `.update()` functions,
for troubleshooting or advanced-user purposes only: \itemize{
\item \code{request.only} (Logical) & \code{json.params.only} (Logical) which 1) stop the function before its main curl request to magma and 2) returns the values that would have been sent to magma in either of two formats.
\item \code{verbose} (Logical) sets whether to report the status of the curl request after it is performed.
}}
}
\value{
None directly.

The function sends data to magma, and the only outputs are information reported via the console.
}
\description{
A matrix-specific wrapper of \code{\link{updateValues}} which can take in a matrix, data.frame, or file path, directly.
}
\details{
This function utilizes the magma/query function, documented here \url{https://mountetna.github.io/magma.html#update},
to upload data to a matrix attribute (named \code{attributeName}) of the \code{modelName} model of \code{projectName} project.

\code{matrix} data are provided either as a matrix, dataframe, or file path which points toward such data.
If given as a file path, the \code{separator} input can be used to adjust for whether the file is a csv (the default, \code{separator = ","}), or tsv, \code{separator = "\t"}, or other format.

Data is then validated by ensuring that all row names are among the valid 'options' of the target attribute (See the See Also section below for a note on how to explore these options yourself.).
Rows are reordered to be in the same order as these 'options'.

For any missing 'options', rows of NAs are added.

The data is then transformed and passed along to \code{\link{updateValues}}.

The \code{updateValues()} function will summarize records to be updated and allow the user to double-check this information before proceeding.

This user-prompt step can be bypassed (useful when running in a non-interactive way) by setting \code{auto.proceed = TRUE}, but NOTE:
It is a good idea to always check carefully before proceeding, if possible.
Data can be overwritten with NAs or zeros or the like, but improperly named records cannot be easily removed.
}
\examples{

if (interactive()) {
    # First, we use magmaRset to create an object which will tell other magmaR
    #  functions our authentication token (as well as some other optional bits).
    # When run in this way, it will ask you to give your token.
    magma <- magmaRset()
    
    ### Note that you likely do not have write-permissions for the 'example'
    # project, so this code can be expected to give an authorization error.
    
    ### Retrieve some data from magma, then update that same data.
    mat <- retrieveMatrix(magma, "example", "rna_seq", "all", "gene_tpm")

    updateMatrix(
        target = magma,
        projectName = "example",
        modelName = "rna_seq",
        attributeName = "gene_tpm",
        matrix = mat)
}

}
\seealso{
\code{\link{updateFromDF}} for a more flexible function for uploading multiple attributes-worth of (non-matrix) data at a time.

\code{\link{updateValues}} for the more direct replica of \code{magma/update} which is more even more flexible that \code{updateFromDF}, though a bit more complicated to use.

\code{\link{retrieveTemplate}}, then check the \code{<output>$models$<modelName>$template$attributes$<attributeName>$options} to explore the rownames that your matrix should have.

\url{https://mountetna.github.io/magma.html#update} for documentation of the underlying \code{magma/update} function.
}
