% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/experimental.R
\name{first_label_get}
\alias{first_label_get}
\title{Get the first label from a data dictionary}
\usage{
first_label_get(data_dict)
}
\arguments{
\item{data_dict}{A list of data frame(s) representing metadata.}
}
\value{
A named character vector with the following elements:
\itemize{
\item \code{Variables}: The first variable label found, or an empty string if none are found.
\item \code{Categories}: The first category label found, or \code{NULL} if no categories are present.
\item \code{madshapR::class}: A string indicating the class of the data dictionary.
}
}
\description{
This function retrieves the first variable and category labels from a data dictionary.
It checks if the labels are present, and if not, returns empty strings. The function
also determines the class of the data dictionary based on its attributes and structure.
The function first validates the input using \code{as_data_dict_shape}. It then attempts to
extract the first variable label from the 'Variables' section of the data dictionary.
If categories are present, it will also extract the first relevant category label.
The class of the data dictionary is determined based on its attributes and structure.
}
\details{
A data dictionary contains the list of variables in a dataset and metadata
about the variables and can be associated with a dataset. A data dictionary
object is a list of data frame(s) named 'Variables' (required) and
'Categories' (if any). To be usable in any function, the data frame
'Variables' must contain at least the \code{name} column, with all unique and
non-missing entries, and the data frame 'Categories' must contain at least
the \code{variable} and \code{name} columns, with unique combination of
\code{variable} and \code{name}.
}
\examples{
{
 # use madshapR_examples provided by the package
 data_dict <- madshapR_examples$`data_dictionary_example`
 first_label_get(data_dict)

}

}
