% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/experimental.R
\name{drop_category}
\alias{drop_category}
\title{Validate and coerce any object as a non-categorical variable.}
\usage{
drop_category(x)
}
\arguments{
\item{x}{object to be coerced.}
}
\value{
A R object.
}
\description{
Converts a vector object to a non-categorical object, typically a column in a
data frame. The categories come from valid values present in the
object and are suppressed from an associated data dictionary (when present).
}
\examples{
{

library(dplyr)

###### Example 1: use madshapR_examples provided by the package
dataset <-
  madshapR_examples$`dataset_example` \%>\%
  mutate(prg_ever_cat = as_category(prg_ever)) \%>\%
  mutate(prg_ever_no_cat = drop_category(prg_ever))
  
head(dataset[c("prg_ever_cat","prg_ever_no_cat")])

###### Example 2: any data frame can be a dataset
iris_no_cat <- 
  tibble(iris) \%>\% mutate(Species = drop_category(Species))

head(iris_no_cat)

}

}
