% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cache_manager.R
\name{CacheManager}
\alias{CacheManager}
\title{Cache Manager Class}
\description{
Manages caching of consensus analysis results
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{cache_dir}}{Directory to store cache files. Options:
\itemize{
\item NULL (default): Uses system cache directory
\item "local": Uses .mllmcelltype_cache in current directory
\item "temp": Uses temporary directory
\item Custom path: Any other string is used as directory path
}}

\item{\code{cache_version}}{Current cache version}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-CacheManager-new}{\code{CacheManager$new()}}
\item \href{#method-CacheManager-get_cache_dir}{\code{CacheManager$get_cache_dir()}}
\item \href{#method-CacheManager-generate_key}{\code{CacheManager$generate_key()}}
\item \href{#method-CacheManager-save_to_cache}{\code{CacheManager$save_to_cache()}}
\item \href{#method-CacheManager-load_from_cache}{\code{CacheManager$load_from_cache()}}
\item \href{#method-CacheManager-has_cache}{\code{CacheManager$has_cache()}}
\item \href{#method-CacheManager-get_cache_stats}{\code{CacheManager$get_cache_stats()}}
\item \href{#method-CacheManager-clear_cache}{\code{CacheManager$clear_cache()}}
\item \href{#method-CacheManager-validate_cache}{\code{CacheManager$validate_cache()}}
\item \href{#method-CacheManager-clone}{\code{CacheManager$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CacheManager-new"></a>}}
\if{latex}{\out{\hypertarget{method-CacheManager-new}{}}}
\subsection{Method \code{new()}}{
Initialize cache manager
\itemize{
\item NULL (default): Uses system cache directory via \code{tools::R_user_dir()}
\item "local": Uses .mllmcelltype_cache in current directory
\item "temp": Uses temporary directory (cleared on R restart)
\item Custom path: Any other string is used as directory path
}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CacheManager$new(cache_dir = NULL)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CacheManager-get_cache_dir"></a>}}
\if{latex}{\out{\hypertarget{method-CacheManager-get_cache_dir}{}}}
\subsection{Method \code{get_cache_dir()}}{
Get actual cache directory path
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CacheManager$get_cache_dir()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CacheManager-generate_key"></a>}}
\if{latex}{\out{\hypertarget{method-CacheManager-generate_key}{}}}
\subsection{Method \code{generate_key()}}{
Generate cache key from input parameters (improved version)
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CacheManager$generate_key(
  input,
  models,
  cluster_id,
  tissue_name = "",
  top_gene_count = 10
)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CacheManager-save_to_cache"></a>}}
\if{latex}{\out{\hypertarget{method-CacheManager-save_to_cache}{}}}
\subsection{Method \code{save_to_cache()}}{
Save results to cache
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CacheManager$save_to_cache(key, data)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CacheManager-load_from_cache"></a>}}
\if{latex}{\out{\hypertarget{method-CacheManager-load_from_cache}{}}}
\subsection{Method \code{load_from_cache()}}{
Load results from cache
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CacheManager$load_from_cache(key)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CacheManager-has_cache"></a>}}
\if{latex}{\out{\hypertarget{method-CacheManager-has_cache}{}}}
\subsection{Method \code{has_cache()}}{
Check if results exist in cache
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CacheManager$has_cache(key)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CacheManager-get_cache_stats"></a>}}
\if{latex}{\out{\hypertarget{method-CacheManager-get_cache_stats}{}}}
\subsection{Method \code{get_cache_stats()}}{
Get cache statistics
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CacheManager$get_cache_stats()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CacheManager-clear_cache"></a>}}
\if{latex}{\out{\hypertarget{method-CacheManager-clear_cache}{}}}
\subsection{Method \code{clear_cache()}}{
Clear all cache
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CacheManager$clear_cache(confirm = FALSE)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CacheManager-validate_cache"></a>}}
\if{latex}{\out{\hypertarget{method-CacheManager-validate_cache}{}}}
\subsection{Method \code{validate_cache()}}{
Validate cache content
Extract genes from input in a standardized way
Create stable hash from genes list
Create stable hash from models list
Create stable hash from tissue_name and top_gene_count
Create stable hash from cluster ID
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CacheManager$validate_cache(key)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CacheManager-clone"></a>}}
\if{latex}{\out{\hypertarget{method-CacheManager-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CacheManager$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
