% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adjust_palette.R
\name{custom_adjust_ltc}
\alias{custom_adjust_ltc}
\title{Create Custom Palette with Individual Color Adjustments}
\usage{
custom_adjust_ltc(palette_name, adjustments)
}
\arguments{
\item{palette_name}{Character or unquoted name. Name of the ltc palette.}

\item{adjustments}{Numeric vector. Lightness adjustments for each color (-100 to 100).
Length must match the palette length.}
}
\value{
A vector of adjusted hex color codes with class "ltc"
}
\description{
Apply different lightness adjustments to each color in a palette.
}
\examples{
\donttest{
# Different adjustment for each color
custom_adjust_ltc(remains, c(-30, 0, 40, 0))

# Create gradient effect
custom_adjust_ltc("maya", c(-40, -20, 0, 20, 40))
}
}
