% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lsoda.R
\name{ode}
\alias{ode}
\title{Ordinary differential equation solver using lsoda}
\usage{
ode(y, times, func, parms, rtol = 1e-06, atol = 1e-06, ...)
}
\arguments{
\item{y}{vector of initial state values}

\item{times}{vector of times -- including the start time}

\item{func}{R function with signature function(t,y,parms,...) that returns a
list. The first list element is a vector for dy/dt. The second list
elements, if it exists, is a vector of result calculations to be retained.}

\item{parms}{list or vector of parameters that are pass to func}

\item{rtol}{double for the relative tolerance}

\item{atol}{double for the absolute tolerance}

\item{...}{other parameters that are passed to func}
}
\value{
a matrix for times in the first column and the state andd results values in the other columns.
}
\description{
Ordinary differential equation solver using lsoda
}
\examples{
 times = c(0,0.4*10^(0:10))
 y = c(1,0,0)
 func = function(t,y,parms,b=-0.04E0) {
     ydot = rep(0,3)
     ydot[1] = parms$a * y[2] * y[3] + b * y[1]
     ydot[3] = 3.0E7 * y[2] * y[2]
     ydot[2] = -1.0 * (ydot[1] + ydot[3])
     list(ydot, sum(y))
 }
 lsoda::ode(y, times, func, parms=list(a=1.0E4), rtol=1e-8, atol=1e-8)
}
