% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/l_layer.R
\name{l_layer_group}
\alias{l_layer_group}
\title{layer a group node}
\usage{
l_layer_group(widget, label = "group", parent = "root", index = 0)
}
\arguments{
\item{widget}{widget path name as a string}

\item{label}{label used in the layers inspector}

\item{parent}{group layer}

\item{index}{of the newly added layer in its parent group}
}
\value{
layer object handle, layer id
}
\description{
Loon's displays that are based on Cartesian coordinates (i.e.
  scatterplot, histogram and graph display) allow for layering visual
  information including polygons, text and rectangles.

A group layer can contain other layers. If the group layer is
  invisible, then so are all its children.
}
\details{
For more information run: \code{l_help("learn_R_layer")}
}
\examples{
if (interactive()){
p <- l_plot(x=c(1,10,1.5,7,4.3,9,5,2,8),
             y=c(1,10,7,3,4,3.3,8,3,4),
             title="Demo Layers")

id.g <- l_layer_group(p, "A Layer Group")
id.pts <- l_layer_points(p, x=c(3,6), y=c(4,7), color="red", parent=id.g)
l_scaleto_layer(p, id.pts)
l_configure(id.pts, x=c(-5,5,12), y=c(-2,-5,18), color="lightgray")

}
}
\seealso{
\code{\link{l_layer}}, \code{\link{l_info_states}}
}
