% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weiGpdLik.R
\name{weiGpdLik}
\alias{weiGpdLik}
\title{Weighted GPD log-likelihood}
\usage{
weiGpdLik(x, y, post)
}
\arguments{
\item{x}{numerical vector (2x1): values of the parameters \eqn{\xi}
and \eqn{\beta}.}

\item{y}{numerical vector (nx1): observed data.}

\item{post}{numerical vector (nx1) with elements in (0,1): weights
of the observations (in the EM algorithm, posterior probabilities).}
}
\value{
llik real: numerical value of the log-likelihood
function
}
\description{
This function evaluates the zero-mean generalized Pareto log-likelihood
function computed with weighted observations.
}
\examples{
y <- rlognGPD(100,.9,0,1,0.5,2)
x0 <- c(.7,.2,1.3,.8,1.7)
res <- EMlogngpdmix(x0, y, 1000)
llik <- weiGpdLik(c(res$beta,res$xi),y,res$post)

}
