% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rlognGPD.R
\name{rlognGPD}
\alias{rlognGPD}
\title{Simulation of the lognormal-GPD mixture}
\usage{
rlognGPD(n, p, mu, sigma, xi, beta)
}
\arguments{
\item{n}{positive integer: number of observations sampled.}

\item{p}{real, 0<p<1: prior probability}

\item{mu}{real: log-mean of the lognormal distribution.}

\item{sigma}{positive real: log-standard deviation of the
lognormal distribution.}

\item{xi}{real: shape parameter of the generalized Pareto distribution.}

\item{beta}{positive real: scale parameter of the generalized Pareto distribution.}
}
\value{
ysim (n x 1) vector: n random numbers from the
lognormal - generalized Pareto mixture.
}
\description{
This function simulates a lognormal-GPD mixture.
}
\examples{
ysim <- rlognGPD(100,.9,0,1,0.5,2)

}
