% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/many_lm_to_partable.R
\name{lm_list_to_partable}
\alias{lm_list_to_partable}
\title{Convert a 'lm_list' Object To a Parameter Table}
\usage{
lm_list_to_partable(
  object,
  keep_intercepts = FALSE,
  vcov_args = list(),
  pvalue_fun = NULL,
  rsquare = FALSE,
  ci = FALSE,
  ci_fun = stats::confint,
  ci_args = list(level = 0.95)
)
}
\arguments{
\item{object}{The output of
\code{\link[=many_lm]{many_lm()}} or \code{\link[manymome:lm2list]{manymome::lm2list()}}.}

\item{keep_intercepts}{Logical. If
\code{TRUE}, the intercepts of the
regression models and the means of
the "pure" predictors (variables not
being the outcome variables of any of
the regression models) are kept in
the parameter table. If \code{FALSE}, the
default, all intercepts and means
will be removed.}

\item{vcov_args}{A named list of
arguments to be passed to \code{\link[stats:vcov]{stats::vcov()}}
when computing the standard errors
of the regression coefficients.
Default is \code{list()}, an empty list.}

\item{pvalue_fun}{The function to be
used to compute the \emph{p}-values of
regression coefficients. Ignored for
now. Included for adding this feature
in the future.}

\item{rsquare}{Logical. Whether
R-squares will be included in the
output, with \code{r2} as the operator
in the column \code{op}. Default is
\code{FALSE}. Not included by default
because \code{\link[semPlot:semPaths]{semPlot::semPaths()}} will
draw the R-squares over the residual
variances.}

\item{ci}{Logical. If \code{TRUE},
confidence intervals will be added,
computed by \code{\link[stats:confint]{stats::confint()}}.}

\item{ci_fun}{The function to be used
to form the confidence intervals for
regression coefficients. Default
is \code{stats::confint}}

\item{ci_args}{A named list of
arguments to be passed to \code{ci_fun}.
Default is \code{list(level = .95)},
requesting 95\% confidence intervals.}
}
\value{
A data frame object with columns such
as \code{lhs}, \code{op}, \code{rhs}, and \code{est},
major columns of the output of
\code{\link[lavaan:parTable]{lavaan::parameterTable()}} necessary
for plotting the model using
\code{\link[semPlot:semPaths]{semPlot::semPaths()}}.
}
\description{
Convert the output of
\code{many_lm()} to a \code{lavann}-style
parameter table.
}
\details{
This function convert a a
lit of \code{lm} objects, such as the
output of \code{\link[=many_lm]{many_lm()}} or
\code{\link[manymome:lm2list]{manymome::lm2list()}}, to a table of
parameter estimates similar to the
output of \link[lavaan:parTable]{lavaan::parameterTable}.

The output is designed to be used by
\code{\link[semPlot:semPaths]{semPlot::semPaths()}} and so contains
only information necessary for the
plot.

The output of \code{\link[stats:lm]{stats::lm()}} is
already supported by
\code{\link[semPlot:semPaths]{semPlot::semPaths()}}, and it can
also combine a list of regression
models into on single plot. However,
it will convert interaction terms to
knots. Moreover, if two interaction
terms in two different models share
the a variable, it will be incorrectly
combined to become a single knot
(Version 1.1.6). Therefore, this
function was developed to let users
to draw the model as if it were a
path model in structural equation
modeling.
}
\examples{

data(data_test1)
mod <- "x3 ~ x2*x1
        x4 ~ x3
        x5 ~ x4 + x3"
out <- many_lm(mod, data_test1)
out_ptable <- lm_list_to_partable(out)
out_ptable

m <- matrix(c("x1", "x2", "x2:x1", NA, "x3", NA, "x4", NA, NA, NA, "x5", NA),
            nrow = 3, ncol = 4)
m

# The output can be used by semPlot::semPaths()

if (requireNamespace("semPlot", quietly = TRUE)) {
  library(semPlot)
  p <- semPaths(out_ptable,
                what = "paths",
                whatLabels = "est",
                nCharNodes = 0,
                style = "ram",
                layout = m,
                exoCov = FALSE,
                DoNotPlot = TRUE)
  plot(p)

  # If it is desired to use knots to
  # denote interaction terms, then,
  # the output of many_lm() can be used
  # directly.

  m2 <- matrix(c("x1", NA, "x2", NA, "x3", NA, "x4", NA, NA, NA, "x5", NA),
            nrow = 3, ncol = 4)
  p2 <- semPaths(out,
                 what = "paths",
                 whatLabels = "est",
                 nCharNodes = 0,
                 style = "ram",
                 layout = m2,
                 exoCov = FALSE,
                 intercepts = FALSE,
                 DoNotPlot = TRUE)
  plot(p2)

  # This illustrates the problem with using
  # the list of lm-outputs directly when
  # a variable is involved in the interaction terms
  # of two or more models.

  m3 <- matrix(c("x2",   NA, "x1",   NA, "x3",
                   NA,   NA,   NA,   NA,   NA,
                   NA, "x4",   NA, "x5",   NA),
            nrow = 5, ncol = 3)
  mod3 <- "x4 ~ x2*x1
           x5 ~ x3*x1"
  out3 <- many_lm(mod3, data_test1)
  p3 <- semPaths(out3,
                 what = "paths",
                 whatLabels = "est",
                 nCharNodes = 0,
                 style = "ram",
                 layout = m3,
                 exoCov = FALSE,
                 intercepts = FALSE,
                 DoNotPlot = TRUE)
  plot(p3)

}

}
\seealso{
\code{\link[=many_lm]{many_lm()}} and \code{\link[manymome:lm2list]{manymome::lm2list()}}.
}
\author{
Shu Fai Cheung \url{https://orcid.org/0000-0002-9871-9448}
}
