% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.mru.R
\name{plot.mru}
\alias{plot.mru}
\title{Plots a Multinomial Restricted MDU model}
\usage{
\method{plot}{mru}(
  x,
  dims = c(1, 2),
  class.regions = FALSE,
  ycol = "darkgreen",
  xcol = "darkblue",
  ocol = "grey",
  markersize = 2.5,
  labelsize = 3,
  ...
)
}
\arguments{
\item{x}{an object of type mru}

\item{dims}{which dimensions to visualize}

\item{class.regions}{whether a voronoi diagram with classification regions should be included}

\item{ycol}{colour for representation of response variables}

\item{xcol}{colour for representation of predictor variables}

\item{ocol}{colour for representation of row objects}

\item{markersize}{size of points}

\item{labelsize}{size of labels}

\item{\dots}{additional arguments to be passed.}
}
\value{
Plot of the results obtained from mru
}
\description{
Plots a Multinomial Restricted MDU model
}
\examples{
\dontrun{
data(dataExample_mru)
y = as.matrix(dataExample_mru[ , 1])
X = as.matrix(dataExample_mru[ , 2:6])
output = mru(y = y, X = X, S = 2)
plot(output)
}

}
