% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_delta.R
\name{get_delta}
\alias{get_delta}
\title{Calculate delta}
\usage{
get_delta(from, to, f, alpha = 0.05)
}
\arguments{
\item{from}{A vector of infectors.}

\item{to}{A vector of infectees.}

\item{f}{A named numeric value representing the prevalence of each group in the population or directly the group sizes.}

\item{alpha}{The significance level for the confidence interval.}
}
\value{
A data frame with the estimated delta, lower and upper confidence limits for each group.
}
\description{
Computes the scaled tansmission assortativity coefficient, see function \code{\link{gamma2delta}}.
}
\examples{
from <- c("A", "A", NA, "C", "C", "C")
to <- c("A", "B", "B", "C", "C", "C")
f <- c(A = 0.3, B = 0.2, C = 0.5)
get_delta(from, to, f, alpha = 0.05)
}
