% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotly.R
\name{apply_default_plotly_behavior}
\alias{apply_default_plotly_behavior}
\title{Apply Default Plotly Behavior for Selection Highlighting}
\usage{
apply_default_plotly_behavior(plot_proxy, selected_row, session, component_id)
}
\arguments{
\item{plot_proxy}{plotlyProxy object for the target plot.}

\item{selected_row}{Data frame row containing the selected data point, or NULL for deselection.}

\item{session}{Shiny session object for the current user session.}

\item{component_id}{Character string. ID of the plotly component for reference.}
}
\value{
NULL (invisible). Function is called for side effects only.
}
\description{
Implements selection highlighting using plotly's native selectedpoints mechanism.
This leverages plotly's built-in selection system which works consistently across
all chart types without hardcoded styling values.
}
\details{
This function uses plotly's native selection capabilities by:
\itemize{
\item Finding points using key or customdata across all traces
\item Applying plotly's built-in selectedpoints styling
\item Using plotly's default selected/unselected appearance
\item Working generically across all plot types and trace structures
}
For native plotly selection highlighting to work, your Shiny UI must include a custom JavaScript message handler:
\preformatted{
tags$script(HTML("
  Shiny.addCustomMessageHandler('eval', function(code) {
    try {
      eval(code);
    } catch(e) {
      console.error('JavaScript execution error:', e);
    }
  });
"))
}

This enables linkeR to send selection updates to plotly charts for visual feedback.

The selection highlighting follows plotly's native behavior and appearance,
ensuring consistency with user expectations and plotly's design system.
}
\keyword{internal}
