% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mle_format.R
\name{mle_format}
\alias{mle_format}
\title{Extract and format results from Simulated Annealing (Maximum Likelihood Estimation)}
\usage{
mle_format(x, yvar)
}
\arguments{
\item{x}{List with the results of the simulated annealing algorithm for Maximum
Likelihood Estimation. See \code{\link[likelihood:anneal]{likelihood::anneal()}}}

\item{yvar}{The name of the column that contains the dependent variable
(the “observed” value). This column must be present in the \code{source_data}
of the \code{x} (results) list}
}
\value{
A dataframe with outputs from the results of the simulated
annealing maximum parameter estimation. This dataframe contains the following
columns (see help in \code{\link[likelihood:anneal]{likelihood::anneal()}}):
\itemize{
\item \code{max_likeli} The maximum likelihood value of the model
\item \code{n_params} The number of the estimated parameters
\item \code{aic_corr} The value of Akaike's Information Criterion “corrected” for
small sample size. See the "Simulated Annealing Algorithm" help
page of the \href{https://cran.r-project.org/package=likelihood}{likelihood} package for more information.
\item \code{aic} The value of Akaike's Information Criterion. See the
"Simulated Annealing Algorithm" help page of the \href{https://cran.r-project.org/package=likelihood}{likelihood}
package for more information.
\code{slope} Slope of observed values linearly regressed on those predicted by
model, using the parameter maximum likelihood estimates. The intercept is
forced at zero.
\item \code{R2}	Proportion of variance explained by the model relative to that explained
by the simple mean of the data.
\item \code{rmse} Root Mean Square Error, \emph{i.e.} the standard deviation of the residuals.
It is computed as:
}

\deqn{RMSE=\sqrt{ \frac{\sum_{i=1}^{N}(obs_i - exp_i)^2}{n -1}}}
}
\description{
Extract and format results from Simulated Annealing (Maximum Likelihood Estimation)
}
\examples{

# Get the results of the maximum likelihood estimation from the example in
# the anneal function of the likelihood pkg.

library(likelihood)
data(crown_rad)
dataset <- crown_rad

# Create our model function
modelfun <- function (a, b, DBH) {a + b * DBH}

# Compute the MLE of the parameters
results <- anneal(model = modelfun,
  par = list(a = 0, b = 0),
  var = list(DBH = "DBH", x = "Radius", mean = "predicted",
             sd = 0.815585, log = TRUE),
  source_data = dataset,
  par_lo = list(a = 0, b = 0),
  par_hi = list(a = 50, b = 50),
  pdf = dnorm,
  dep_var = "Radius",
  max_iter = 20000,
  show_display = FALSE)

# Format the results
mle_format(results, yvar = "DBH")

}
