# lightsf - Collection of georeferenced and spatial datasets from different domains
# Version 0.1.0
# Copyright (C) 2025 Ingrid Romero Pinilla
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <https://www.gnu.org/licenses/>.

# cyclehire_pts

library(testthat)

# Test 1: Confirm the object is an sf and a data.frame
test_that("cyclehire_pts is an sf and a data.frame", {
  expect_s3_class(cyclehire_pts, "sf")
  expect_s3_class(cyclehire_pts, "data.frame")
})

# Test 2: Confirm it has exactly 6 columns
test_that("cyclehire_pts has 6 columns", {
  expect_equal(length(cyclehire_pts), 6)
})

# Test 3: Confirm it has exactly 742 rows
test_that("cyclehire_pts has 742 rows", {
  expect_equal(nrow(cyclehire_pts), 742)
})

# Test 4: Confirm column names are correct
test_that("cyclehire_pts has correct column names", {
  expect_named(cyclehire_pts, c(
    "id", "name", "area", "nbikes", "nempty", "geometry"
  ))
})

# Test 5: Confirm column types are as expected
test_that("cyclehire_pts columns have correct types", {
  expect_type(cyclehire_pts$id, "integer")
  expect_s3_class(cyclehire_pts$name, "factor")
  expect_s3_class(cyclehire_pts$area, "factor")
  expect_type(cyclehire_pts$nbikes, "integer")
  expect_type(cyclehire_pts$nempty, "integer")
  expect_s3_class(cyclehire_pts$geometry, "sfc_POINT")
})

# Test 6: Confirm geometry column integrity
test_that("cyclehire_pts geometry column is valid", {
  expect_true("geometry" %in% names(cyclehire_pts))
  expect_equal(attr(cyclehire_pts, "sf_column"), "geometry")
})
