% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/4_financialFunctions.R
\name{presentValue}
\alias{presentValue}
\title{Present value of a series of cash flows}
\usage{
presentValue(cashFlows, timeIds, interestRates, probabilities, power = 1)
}
\arguments{
\item{cashFlows}{Numeric vector of cash flows. Must be coherent with \code{timeIds}.}

\item{timeIds}{Numeric vector of time points where \code{cashFlows} are due.}

\item{interestRates}{A single numeric interest rate or a numeric vector of the same
length as \code{timeIds} used to discount cash flows.}

\item{probabilities}{Optional numeric vector of occurrence probabilities. If
missing, a vector of ones (certainty) is assumed.}

\item{power}{Numeric power applied to discount and cash flows. Defaults to 1.}
}
\value{
A numeric scalar representing the present value of the cash flow vector,
or the actuarial present value if \code{probabilities} are provided.
}
\description{
This function evaluates the present values of a series of cash flows,
given occurrence time. Probabilities of occurrence can also be taken into account.
}
\details{
Present value of a series of cash flows.

Evaluate the present value (or actuarial present value when
probabilities are provided) of a vector of cash flows occurring at
given time instants and discounted by provided interest rates.

\code{probabilities} is optional; when omitted a sequence of 1's with the
same length as \code{timeIds} is assumed. Interest rate may be a fixed number
or a vector of the same size as \code{timeIds}. The \code{power} parameter is
normally unused except in specialised actuarial evaluations.
}
\note{
This simple function is the kernel working core of the package. Actuarial and financial mathematics ground on it.
}
\examples{
# simple example
cf <- c(10,10,10)    # $10 payments one per year for three years
t  <- c(1,2,3)       # years
p  <- c(1,1,1)       # payments certainty
presentValue(cashFlows = cf, timeIds = t, interestRates = 0.03, probabilities = p)
}
\references{
Broverman, S.A., Mathematics of Investment and Credit (Fourth Edition), 2008, ACTEX Publications.
}
\author{
Giorgio A. Spedicato
}
