% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Layout.R
\name{LayoutGlue}
\alias{LayoutGlue}
\title{Format Log Events as Text via glue}
\description{
Format a \link{LogEvent} as human readable text using \link[glue:glue]{glue::glue}. The function
is evaluated in an environment in which it has access to all elements of
the \link{LogEvent} (see examples). This is more flexible than \link{LayoutFormat},
but also more complex and slightly less performant.
}
\examples{
lg <- get_logger("test")$
  set_appenders(AppenderConsole$new())$
  set_propagate(FALSE)

lg$appenders[[1]]$set_layout(LayoutGlue$new())
lg$fatal("test")


# All fields of the LogEvent are available, even custom ones
lg$appenders[[1]]$layout$set_fmt(
  "{logger} {level_name}({level}) {caller}: {toupper(msg)} {{custom: {custom}}}"
)
lg$fatal("test", custom = "foobar")
lg$config(NULL)  # reset logger config
}
\seealso{
lgr exports a number of formatting utility functions that are
useful for layout glue: \code{\link[=colorize_levels]{colorize_levels()}}, \code{\link[=pad_left]{pad_left()}}, \code{\link[=pad_right]{pad_right()}}.

Other Layouts: 
\code{\link{Layout}},
\code{\link{LayoutFormat}},
\code{\link{LayoutJson}}
}
\concept{Layouts}
\section{Super class}{
\code{\link[lgr:Layout]{lgr::Layout}} -> \code{LayoutGlue}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{fmt}}{A string that will be interpreted by \code{\link[glue:glue]{glue::glue()}}}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-LayoutGlue-new}{\code{LayoutGlue$new()}}
\item \href{#method-LayoutGlue-format_event}{\code{LayoutGlue$format_event()}}
\item \href{#method-LayoutGlue-set_fmt}{\code{LayoutGlue$set_fmt()}}
\item \href{#method-LayoutGlue-set_colors}{\code{LayoutGlue$set_colors()}}
\item \href{#method-LayoutGlue-toString}{\code{LayoutGlue$toString()}}
\item \href{#method-LayoutGlue-clone}{\code{LayoutGlue$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="lgr" data-topic="Layout" data-id="set_excluded_fields"><a href='../../lgr/html/Layout.html#method-Layout-set_excluded_fields'><code>lgr::Layout$set_excluded_fields()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LayoutGlue-new"></a>}}
\if{latex}{\out{\hypertarget{method-LayoutGlue-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LayoutGlue$new(
  fmt = "{pad_right(colorize_levels(toupper(level_name)), 5)} [{timestamp}] {msg}"
)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LayoutGlue-format_event"></a>}}
\if{latex}{\out{\hypertarget{method-LayoutGlue-format_event}{}}}
\subsection{Method \code{format_event()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LayoutGlue$format_event(event)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LayoutGlue-set_fmt"></a>}}
\if{latex}{\out{\hypertarget{method-LayoutGlue-set_fmt}{}}}
\subsection{Method \code{set_fmt()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LayoutGlue$set_fmt(x)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LayoutGlue-set_colors"></a>}}
\if{latex}{\out{\hypertarget{method-LayoutGlue-set_colors}{}}}
\subsection{Method \code{set_colors()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LayoutGlue$set_colors(x)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LayoutGlue-toString"></a>}}
\if{latex}{\out{\hypertarget{method-LayoutGlue-toString}{}}}
\subsection{Method \code{toString()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LayoutGlue$toString()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LayoutGlue-clone"></a>}}
\if{latex}{\out{\hypertarget{method-LayoutGlue-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LayoutGlue$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
