% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bernoulli.R
\name{bernoulli}
\alias{bernoulli}
\alias{fit_bernoulli}
\alias{logLikVec.bernoulli}
\alias{nobs.bernoulli}
\alias{coef.bernoulli}
\alias{vcov.bernoulli}
\alias{logLik.bernoulli}
\alias{alogLik.bernoulli}
\title{Inference for the Bernoulli distribution}
\usage{
fit_bernoulli(data)

\method{logLikVec}{bernoulli}(object, pars = NULL, ...)

\method{nobs}{bernoulli}(object, ...)

\method{coef}{bernoulli}(object, ...)

\method{vcov}{bernoulli}(object, ...)

\method{logLik}{bernoulli}(object, ...)

\method{alogLik}{bernoulli}(x, cluster = NULL, use_vcov = TRUE, ...)
}
\arguments{
\item{data}{A numeric vector of outcomes from Bernoulli trials: 0 for a
failure, 1 for a success.  Alternatively, a logical vector with FALSE
for a failure and TRUE for a success.}

\item{pars}{A numeric parameter vector of length 1 containing the value of
the Bernoulli success probability.}

\item{...}{Further arguments to be passed to the functions in the
sandwich package \code{\link[sandwich]{meat}} (if \code{cluster = NULL}),
or \code{\link[sandwich:vcovCL]{meatCL}} (if \code{cluster} is not
\code{NULL}).}

\item{x, object}{A fitted model object returned from \code{fit_bernoulli()}.}

\item{cluster}{A vector or factor indicating from which cluster each
observation in \code{data} originates.}

\item{use_vcov}{A logical scalar.  Should we use the \code{vcov} S3 method
for \code{x} (if this exists) to estimate the Hessian of the independence
loglikelihood to be passed as the argument \code{H} to
\code{\link[chandwich]{adjust_loglik}}?
Otherwise, \code{H} is estimated inside
\code{\link[chandwich]{adjust_loglik}} using
\code{\link[stats:optim]{optimHess}}.}
}
\value{
\code{fit_bernoulli} returns an object of class \code{"bernoulli"}, a list
with components: \code{logLik, mle, nobs, vcov, data, obs_data}, where
\code{data} are the input data and \code{obs_data} are the input data after
any missing values have been removed, using
\code{\link[stats:na.fail]{na.omit}}.

\code{logLikVec.bernoulli} returns an object of class \code{"logLikVec"}, a
vector of length \code{length(data)} containing the loglikelihood
contributions from the individual observations in \code{data}.
}
\description{
Functions involved in making inferences about the probability of success
in a Bernoulli distribution.
}
\details{
\code{fit_bernoulli}: fit a Bernoulli distribution

\code{logLikVec.bernoulli}: calculates contributions to a loglikelihood based
on the Bernoulli distribution.  The loglikelihood is calculated up to an
additive constant.

\code{nobs, coef, vcov} and \code{logLik} methods are provided.
}
\examples{
# Set up data
x <- exdex::newlyn
u <- quantile(x, probs = 0.9)
exc <- x > u

# Fit a Bernoulli distribution
fit <- fit_bernoulli(exc)

# Calculate the loglikelihood at the MLE
res <- logLikVec(fit)

# The logLik method sums the individual loglikelihood contributions.
logLik(res)

# nobs, coef, vcov, logLik methods for objects returned from fit_bernoulli()
nobs(fit)
coef(fit)
vcov(fit)
logLik(fit)

# Adjusted loglikelihood
# Create 5 clusters each corresponding approximately to 1 year of data
cluster <- rep(1:5, each = 579)[-1]
afit <- alogLik(fit, cluster = cluster, cadjust = FALSE)
summary(afit)
}
\seealso{
\code{\link[stats]{Binomial}}.  The Bernoulli distribution is the
  special case where \code{size = 1}.
}
