% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createNparReg.R
\name{createNparReg}
\alias{createNparReg}
\title{Performs nonparametric regression on irregular regions.}
\usage{
createNparReg(formLatticeOutput, Z, PointPattern = NULL, M = 0.5, k)
}
\arguments{
\item{formLatticeOutput}{An object returned by formLattice or editLattice.}

\item{Z}{Vector of responses to be smoothed.}

\item{PointPattern}{A 2 column matrix or data frame of locations.}

\item{M}{The maximum probability that the random walk will move.}

\item{k}{Number of steps.}
}
\value{
A list of class NparRegOut with elements:
\itemize{
 \item EW_locs Vector of EW locations.
 \item NS_locs Vector of NS locations.
 \item nodes Matrix of node locations in lattice.
 \item boundaryPoly Matrix showing bounding polynomial.
 \item hole_list List of polygons, holes in region.
 \item PointPattern Matrix of the locations of the data.
 \item which_nodes Matrix locations of nodes closest to data.
 \item NparRegNum Vector of numerators of the regression estimates
 \item NparRegDenom Vector of denominators of the regression estimates
 \item sigma2 Numeric, estimate of the noise variance.
 }
}
\description{
This function takes the lattice from formLattice (which fills the 
region of interest) along with the list of responses and their locations,
and creates a prediction surface.  The approach is kernel non-parametric
regression with the kernels created by a k-step diffusion on the
lattice about each location where a response was collected.
}
\details{
We denote by \eqn{K_{ik}(s)} the kernel obtained by assigning the node
nearest to the ith response and then running a k-step diffusion on 
the lattice and evaluating the resulting density at location s.  
Then the estimator \eqn{\hat{f}(s) = (\sum_i K_{ik}(s)*Z_i)/\sum_i K_{ik}(s)}
which is the traditional kernal regression estimator with diffusion 
kernels.  This approach leads to a non-parametric regression that
respects the boundaries of the polygonal region.  The construction of the
kernels is detailed in Barry and McIntyre (2011).  Using kernels to 
perform nonparametric regression is described in many publications, including
Wasserman (2006).
}
\section{Variance Estimation}{
  We use the variance estimator \eqn{\sum e_{i,-i}^2/n}, where \eqn{e_{i,-i}} is the ith deleted residual.
}

\examples{
data(nparExample)
attach(nparExample)
plot.new()
#  Simulate a response variable
index1 = (grid2[,2]<0.8)|(grid2[,1]>0.6)
Z = rep(NA,length(grid2[,1]))
n1 = sum(index1)
n2 = sum(!index1)
Z[index1] <- 3*grid2[index1,1] + 4 + rnorm(n1,0,sd=0.4)
Z[!index1] <- -2*grid2[!index1,1] + 4 + rnorm(n2,0,sd=0.4)
#
coords=rbind(polygon2,polygon2[1,])
plot(coords,type="l")
points(grid2,pch=19,cex=0.5,xlim=c(-0.1,1))
text(grid2,labels=round(Z,1),pos=4,cex=0.5)
#
nodeFillingOutput <- nodeFilling(poly=polygon2, node_spacing=0.025)
plot(nodeFillingOutput)
formLatticeOutput <- formLattice(nodeFillingOutput)
NparRegOut <- createNparReg(formLatticeOutput,Z,PointPattern=grid2,k=2)
plot(NparRegOut)

}
\references{
Larry Wasserman.  All of Nonparametric Statistics.  Springer Science + 
Business Media, Inc. N.Y. 2006.

Julie McIntyre, Ronald P. Barry (2018)  A Lattice-Based 
Smoother for Regions with Irregular Boundaries and Holes.  
Journal of Computational and Graphical Statistics.  
<doi:10.1080/10618600.2017.1375935>
}
