% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/latentnet-package.R
\docType{package}
\name{latentnet-package}
\alias{latentnet}
\alias{latentnet-package}
\title{latentnet: Latent Position and Cluster Models for Statistical Networks}
\description{
Fit and simulate latent position and cluster models for statistical networks. See Krivitsky and Handcock (2008) \doi{10.18637/jss.v024.i05} and Krivitsky, Handcock, Raftery, and Hoff (2009) \doi{10.1016/j.socnet.2009.04.001}.
}
\details{
The package \pkg{latentnet} is used to fit latent cluster random effect
models, where the probability of a network \eqn{g}, on a set of nodes is a
product of dyad probabilities, each of which is a GLM with linear component
\eqn{\eta_{i,j}=\sum_{k=1}^p \beta_k
X_{i,j,k}+d(Z_i,Z_j)+\delta_i+\gamma_j}, where \eqn{X} is an array of dyad
covariates, \eqn{\beta} is a vector of covariate coefficients, \eqn{Z_i} is
the latent space position of node \eqn{i}, \eqn{d(\cdot,\cdot)} is a
function of the two positions: either negative Euclidean
(\eqn{-||Z_i-Z_j||}) or bilinear (\eqn{Z_i\cdot Z_j}), and \eqn{\delta} and
\eqn{\gamma} are vectors of sender and receiver effects. (Note that these
are different from the eigenmodel of Hoff (2007) ``Modeling homophily and
stochastic equivalence in symmetric relational data'', fit by package
\code{eigenmodel}.)

\code{\link[=ergmm]{ergmm()}} specifies models via: \code{g ~ <model terms>} where
\code{g} is a \code{network} object For the list of possible \code{<model
terms>}, see \code{\link[ergm:ergmTerm]{ergmTerm}}. For the list of the possible dyad
distribution families, see \code{\link{families.ergmm}}.

The arguments in the \code{\link[=ergmm]{ergmm()}} function specific to latent
variable models are \code{\link[=ergmm.control]{ergmm.control()}}. See the help page for
\code{\link[=ergmm]{ergmm()}} for the details.

The result of a latent variable model fit is an \code{\link[=ergmm]{ergmm()}} object.
Hence the \code{\link[=summary]{summary()}}, \code{\link[=print]{print()}}, and \code{\link[=plot]{plot()}} methods
apply to the fits.  The \code{\link[=plot.ergmm]{plot.ergmm()}} function has many options
specific to latent variable models.
}
\references{
Mark S. Handcock, Adrian E. Raftery and Jeremy Tantrum (2007).
\emph{Model-Based Clustering for Social Networks}.  Journal of the Royal
Statistical Society: Series A (Statistics in Society), 170(2), 301-354.

Peter D. Hoff (2005). \emph{Bilinear Mixed Effects Models for Dyadic Data}.
Journal of the American Statistical Association, 100(469), 286-295.

Peter D. Hoff, Adrian E. Raftery and Mark S. Handcock (2002).  \emph{Latent
space approaches to social network analysis}.  Journal of the American
Statistical Association, 97(460), 1090-1098.

Pavel N. Krivitsky, Mark S. Handcock, Adrian E. Raftery, and Peter D. Hoff
(2009).  \emph{Representing degree distributions, clustering, and homophily
in social networks with latent cluster random effects models}.  Social
Networks, 31(3), 204-213.

Pavel N. Krivitsky and Mark S. Handcock (2008).  \emph{Fitting Position
Latent Cluster Models for Social Networks with \pkg{latentnet}}. Journal of
Statistical Software, 24(5). \doi{10.18637/jss.v024.i05}

Susan M. Shortreed, Mark S. Handcock, and Peter D. Hoff (2006).
\emph{Positional Estimation within the Latent Space Model for Networks}.
Methodology, 2(1), 24-33.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://statnet.org}
  \item Report bugs at \url{https://github.com/statnet/latentnet/issues}
}

}
\author{
\strong{Maintainer}: Pavel N. Krivitsky \email{pavel@statnet.org} (\href{https://orcid.org/0000-0002-9101-3362}{ORCID})

Authors:
\itemize{
  \item Mark S. Handcock \email{handcock@stat.ucla.edu}
}

Other contributors:
\itemize{
  \item Susan M. Shortreed [contributor]
  \item Jeremy Tantrum [contributor]
  \item Peter D. Hoff [contributor]
  \item Li Wang \email{lxwang@gmail.com} [contributor]
  \item Kirk Li \email{kirkli@uw.edu} [contributor]
  \item Jake Fisher \email{jcf26@duke.edu} [contributor]
  \item Jordan T. Bates \email{jtbates@gmail.com} [contributor]
}

}
\keyword{graphs}
\keyword{models}
\keyword{nonlinear}
\keyword{nonparametric}
\keyword{package}
\keyword{regression}
