% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/abstractbook.R
\name{create_abstractbook}
\alias{create_abstractbook}
\title{Create Book of Abstracts}
\usage{
create_abstractbook(
  data = NULL,
  path = NULL,
  filename = NULL,
  title.column = NULL,
  authors.column = NULL,
  affiliation.column = NULL,
  text.column = NULL,
  frontpage = NULL,
  toc = TRUE,
  toc.title = "Index",
  title.cex = 22,
  authors.cex = 16,
  affiliations.cex = 14,
  text.cex = 14,
  keep.files = FALSE,
  template = NULL
)
}
\arguments{
\item{data}{a data frame including titles, author names, affiliations and abstracts.}

\item{path}{Character. Path to folder where the PDF file will be saved.}

\item{filename}{Character. Filename of the pdf. If NULL, default is "AbstractBook".}

\item{title.column}{Character. Name of the column in \code{data} storing abstracts' titles.}

\item{authors.column}{Character. Name of the column in \code{data} storing authors' names
and affiliations. Numeric (and symbol, e.g. '*') affiliations MUST be specified between brackets.
Authors must be separated using a semi-colon (';').}

\item{affiliation.column}{Character. Name of the column in \code{data} storing the addresses for each
affiliation number (specified between brackets after author names, in \code{authors.column}).
Separations between authors must be specified using a semi-colon (';').}

\item{text.column}{Name of the column in \code{data} storing the abstract text.}

\item{frontpage}{Character. Path to PDF file to be inserted before the book of abstracts (as front page and/or introduction).}

\item{toc}{Logical. If TRUE, a Table of Contents will be included.}

\item{toc.title}{Character. Title to name the Table of Contents. Default is "Index".}

\item{title.cex}{Text font size used for the title. Default is 22.}

\item{authors.cex}{Text font size used for the authors' names. Default is 16.}

\item{affiliations.cex}{Text font size used for the affiliation addresses Default is 14.}

\item{text.cex}{Text font size used for the abstract main text body. Default is 14.}

\item{keep.files}{Logical. Keep the RMarkdown template and associated files
in the output folder? Default is FALSE.}

\item{template}{Character (optional) RMarkdown template to use. If not provided,
using the default template included in \code{labeleR}.}
}
\value{
A PDF file named after \code{filename} is saved on disk, in the folder defined
by \code{path}. If \code{keep.files = TRUE}, an RMarkdown will also
appear in the same folder.
}
\description{
Create a book of abstracts given a dataframe or tibble.
}
\details{
You can copy and modify at your convenience  \href{https://docs.google.com/forms/d/1u4SFWDobQrD8AEvKpvPCdwAZiVGd55B2dAtPmPEfU6E/copy}{this Google form template}
to retrieve abstract information which will match labeleR's requirements for a straightforward use.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
create_abstractbook(
data=abstract.table,
path = "labeleR_output",
filename = "congress_abstractbook",
title.column = "abstract_title",
authors.column = "authors",
affiliation.column = "affiliation",
text.column = "abstract_text",
title.cex = 20,
authors.cex = 15,
affiliations.cex = 14,
text.cex = 12,
frontpage = "Congress_frontpage.pdf"
)
\dontshow{\}) # examplesIf}
}
\author{
Ignacio Ramos-Gutierrez, Julia G. de Aledo, Jimena Martín-Mateo, Francisco Rodriguez-Sanchez
}
