% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comp_fit.R
\name{comp_fit}
\alias{comp_fit}
\alias{RMSE}
\alias{MAE}
\alias{MSE}
\title{Calculate Comparative Fit Measures for Regression Models}
\usage{
comp_fit(model, type = c("auto", "liner", "power"))

RMSE(model, type = c("auto", "liner", "power"))

MAE(model, type = c("auto", "liner", "power"))

MSE(model, type = c("auto", "liner", "power"))
}
\arguments{
\item{model}{A linear model or power regression model of the \code{lm}.}

\item{type}{Character string. Selects the model type: \code{"linear"}, \code{"power"},
or \code{"auto"} (default). In \code{"auto"}, the function detects if the dependent
variable is log-transformed.}
}
\value{
An object of class \code{comp_kvr2}, which is a list containing
the calculated RMSE, MAE, and MSE values.
}
\description{
Calculates goodness-of-fit metrics based on Kvalseth (1985), including
Root Mean Squared Error (RMSE), Mean Absolute Error (MAE), and Mean Squared
Error (MSE). This function provides a unified output for comparing different
model specifications.
}
\details{
The metrics are calculated according to the formulas in Kvalseth (1985):

\itemize{
\item \bold{RMSE}: Root Mean Squared Residual or Error
\deqn{RMSE = \sqrt{\frac{\sum (y - \hat{y})^2}{n}}}
\item \bold{MAE}: Mean Absolute Residual or Error
\deqn{MAE = \frac{\sum |y - \hat{y}|}{n}}
\item \bold{MSE}: Mean Squared Residual or Error (Adjusted for degrees of freedom)
\deqn{MSE = \frac{\sum (y - \hat{y})^2}{n - p}}
}
where \eqn{n} is the sample size and \eqn{p} is the number of model parameters
(including the intercept).

\strong{Note on MSE:} In many modern contexts, "MSE" refers to the mean
squared error without degree-of-freedom adjustment (denominator \eqn{n}).
However, this function follows Kvalseth's definition, which uses \eqn{n - p}
as the denominator.
}
\note{
The power regression model must be based on a logarithmic transformation.

The auto-selection between linear regression and power regression models is determined by whether the dependent variable's name contains “log”.
If the name “log” is intentionally used for a linear regression model, the selection cannot be made correctly.
}
\examples{
# example data set 1. Kvålseth (1985).
df1 <- data.frame(x = c(1:6),
                 y = c(15,37,52,59,83,92))
model_intercept <- lm(y ~ x, df1)
model_without <- lm(y ~ x - 1, df1)
model_power <- lm(log(y) ~ log(x), df1)
comp_fit(model_intercept)
comp_fit(model_without)
comp_fit(model_power)

}
\references{
Tarald O. Kvalseth (1985) Cautionary Note about R 2 , The American Statistician, 39:4, 279-285, \doi{DOI: 10.1080/00031305.1985.10479448}
}
\seealso{
\code{\link[=print.comp_kvr2]{print.comp_kvr2()}}
}
