% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_imputations.R
\name{get_imputations}
\alias{get_imputations}
\title{get_imputations function}
\usage{
get_imputations(x_ts, methods = "all", seed = 1234)
}
\arguments{
\item{x_ts}{A ts object with missing data to be imputed}

\item{methods}{A string or string vector indicating the method or methods
You can choose between the following:

\itemize{
\item{"all" - get imputed values for all methods - Default}
\item{"auto.arima" - State space representation of an ARIMA model}
\item{"StructTS" - State space representation of a structural model}
\item{"seadec" - Seasonal decomposition with Kalman smoothing}
\item{"linear_i" - Linear interpolation}
\item{"spline_i" - Spline interpolation}
\item{"stine_i" - Stineman interpolation}
\item{"simple_ma" - Simple moving average}
\item{"linear_ma" - Linear moving average}
\item{"exponential_ma" - Exponential moving average}
\item{"locf" - Last observation carried forward}
\item{"stl" - Seasonal and trend decomposition with Loess}
}

For further details on these imputation methods please check packages \CRANpkg{imputeTS} and \CRANpkg{forecast}}

\item{seed}{Numeric. Any number}
}
\value{
A list of imputed time series with the selected methods
}
\description{
Function to get imputations from methods compared by kssa
}
\examples{
\donttest{

# Example 1: Get imputed values for airgap_na_ts with the methods of

library("imputeTS")
library("kssa")

# Create 20\% random missing data in tsAirgapComplete time series from imputeTS
airgap_na <- missMethods::delete_MCAR(as.data.frame(tsAirgapComplete), 0.2)

# Convert to time series object
airgap_na_ts <- ts(airgap_na, start = c(1959, 1), end = c(1997, 12), frequency = 12)

my_imputations <- get_imputations(airgap_na_ts, methods = "all")

# my_imputations contains the imputed time series with all methods.
# Access it and choose the one from the best method for your purposes

my_imputations$seadec
plot.ts(my_imputations$seadec)
}



# Example 2: Get imputed values for airgap_na_ts using only a subset of algorithms

library("imputeTS")
library("kssa")

# Create 20\% random missing data in tsAirgapComplete time series from imputeTS
airgap_na <- missMethods::delete_MCAR(as.data.frame(tsAirgapComplete), 0.2)

# Convert to time series object
airgap_na_ts <- ts(airgap_na, start = c(1959, 1), end = c(1997, 12), frequency = 12)

my_imputations <- get_imputations(airgap_na_ts, methods = c("linear_i", "locf"))

# my_imputations contains the imputed time series with all applied
# methods (locf and linear interpolation).
# Access it and choose the one from the best method for your purposes

my_imputations$locf
plot.ts(my_imputations$locf)


}
